<?php
// Sitemap section walker
if ( ! class_exists( 'Lsvr_Townpress_Menu_Widget_Walker' ) ) {
    class Lsvr_Townpress_Menu_Widget_Walker extends Walker_Nav_Menu {

        private $lsvr_unique_id;

        function start_lvl( &$output, $depth = 0, $args = [] ) {
            ob_start(); ?>

            <button class="lsvr-townpress-menu-widget__toggle lsvr-townpress-menu-widget__toggle--level-<?php echo esc_attr( $depth ); ?>" type="button"
                aria-label="<?php echo esc_attr( esc_html__( 'Expand submenu', 'lsvr-townpress-toolkit' ) ); ?>"
                aria-controls="lsvr-townpress-menu-widget__submenu-<?php echo esc_attr( $this->lsvr_unique_id ); ?>"
                aria-haspopup="true"
                aria-expanded="false">
                <span class="lsvr-townpress-menu-widget__toggle-icon"
                    aria-hidden="true"></span>
            </button>

            <ul id="lsvr-townpress-menu-widget__submenu-<?php echo esc_attr( $this->lsvr_unique_id ); ?>"
                class="lsvr-townpress-menu-widget__submenu lsvr-townpress-menu-widget__submenu--level-<?php echo esc_attr( $depth ); ?>"
                aria-labelledby="lsvr-townpress-menu-widget__item-link-<?php echo esc_attr( $this->lsvr_unique_id ); ?>"
                aria-expanded="false"
                role="menu">

            <?php $output .= ob_get_clean();

        }

        function end_lvl( &$output, $depth = 0, $args = [] ) {
            ob_start(); ?>

            </ul>

            <?php $output .= ob_get_clean();
        }

        function start_el( &$output, $item, $depth = 0, $args = [], $id = 0 ) {
            $this->lsvr_unique_id = $item->ID . '-' . rand( 0, 999 );
            ob_start(); ?>

            <?php if ( ! empty( $item->description ) ) {
                $item->classes[] = 'lsvr-townpress-menu-widget__item--has-icon';
            } ?>

            <li id="lsvr-townpress-menu-widget__item-<?php echo esc_attr( $this->lsvr_unique_id ); ?>"
                class="lsvr-townpress-menu-widget__item lsvr-townpress-menu-widget__item--level-<?php echo esc_attr( $depth ); ?> <?php echo ! empty( $item->classes ) ? esc_attr( trim( implode( ' ', $item->classes ) ) ) : ''; ?>"
                role="presentation">

                <a href="<?php echo esc_url( $item->url ); ?>"
                    id="lsvr-townpress-menu-widget__item-link-<?php echo esc_attr( $this->lsvr_unique_id ); ?>"
                    class="lsvr-townpress-menu-widget__item-link lsvr-townpress-menu-widget__item-link--level-<?php echo esc_attr( $depth ); ?>"
                    role="menuitem"

                    <?php if ( in_array( 'menu-item-has-children', $item->classes ) ) : ?>

                        aria-owns="lsvr-townpress-menu-widget__submenu-<?php echo esc_attr( $this->lsvr_unique_id ); ?>"
                        aria-controls="lsvr-townpress-menu-widget__submenu-<?php echo esc_attr( $this->lsvr_unique_id ); ?>"
                        aria-haspopup="true"
                        aria-expanded="false"

                    <?php endif; ?>

                    <?php echo ! empty( $item->post_excerpt ) ? ' title="' . esc_attr( $item->post_excerpt ) . '"' : ''; ?>
                    <?php echo ! empty( $item->target ) ? ' target="' . esc_attr( $item->target ) . '"' : ''; ?>>

                    <?php if ( ! empty( $item->description ) ) : ?>
                        <span class="lsvr-townpress-menu-widget__item-link-icon lsvr-townpress-menu-widget__item-link-icon--level-<?php echo esc_attr( $depth ); ?> <?php echo esc_attr( $item->description ); ?>"
                            aria-hidden="true"></span>
                    <?php endif; ?>

                    <span class="lsvr-townpress-menu-widget__item-link-label">
                        <?php echo esc_html( apply_filters( 'the_title', $item->title, $item->ID ) ); ?>
                    </span>

                </a>

            <?php $output .= ob_get_clean();
        }

        function end_el( &$output, $item, $depth = 0, $args = [] ) {
            ob_start(); ?>

            </li>

            <?php $output .= ob_get_clean();

        }

    }
}