<?php
/**
 * LSVR TownPress Posts Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Townpress_Posts' ) ) {
    class Lsvr_Shortcode_Townpress_Posts {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Prepare default atts
            $default_atts = array(
                'title' => '',
                'icon' => '',
                'category' => 0,
                'limit' => 8,
                'featured_limit' => 1,
                'more_label' => '',
                'id' => '',
                'className' => '',
                'editor_view' => false,
            );

            // Merge default atts with custom atts
            if ( ! empty( apply_filters( 'lsvr_townpress_posts_shortcode_atts', array() ) ) ) {

                $default_atts = array_merge(
                    $default_atts,
                    array_fill_keys( array_column( apply_filters( 'lsvr_townpress_posts_shortcode_atts', array() ), 'name' ), '' )
                );

            }

            // Merge default atts and received atts
            $args = shortcode_atts(
                $default_atts,
                $atts
            );

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Element class
            $class_arr = array( 'lsvr-townpress-posts' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr-townpress-posts--editor-view' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            // Prepare query
            $limit = 0 === (int) $args['limit'] ? 1000 : (int) $args['limit'];
            $query_args = array(
                'posts_per_page' => $limit,
                'post_type' => 'post',
            );

            // Get category
            if ( ! empty( $args['category'] ) && is_numeric( $args['category'] ) && (int) $args['category'] > 0 ) {
                $category_id = (int) $args['category'];
            } else if ( ! empty( $args['category'] ) ) {
                $category_id = get_term_by( 'slug', $args['category'], 'category', ARRAY_A );
                $category_id = ! empty( $category_id['term_taxonomy_id'] ) ? $category_id['term_taxonomy_id'] : false;
            } else {
                $category_id = false;
            }

            // Set category
            if ( ! empty( $category_id ) ) {
                $query_args['tax_query'] = array(
                    array(
                        'taxonomy' => 'category',
                        'field' => 'term_id',
                        'terms' => $category_id,
                    ),
                );
            }

            // Get posts
            $posts = new WP_Query( $query_args );
            wp_reset_query();

            // Prepare template vars
            global $lsvr_template_vars;
            $lsvr_template_vars = array(
                'args' => $args,
                'category_id' => $category_id,
                'blog_posts' => ! empty( $posts->posts ) ? $posts->posts : false,
                'class_arr' => $class_arr,
                'editor_view' => $editor_view,
            );

            ob_start();

            // Load template
            if ( function_exists( 'lsvr_framework_load_template' ) ) {
                lsvr_framework_load_template( apply_filters( 'lsvr_shortcode_townpress_posts_template_path', 'lsvr-townpress-toolkit/templates/shortcodes/townpress-posts.php' ) );
            }

            return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'Title of this section.', 'lsvr-townpress-toolkit' ),
                    'default' => esc_html__( 'Latest News', 'lsvr-townpress-toolkit' ),
                    'priority' => 10,
                ),

                // Icon
                array(
                    'name' => 'icon',
                    'type' => 'text',
                    'label' => esc_html__( 'Icon', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'Icon name. Please refer to the documentation to learn more about icons.', 'lsvr-townpress-toolkit' ),
                    'default' => 'icon-reading',
                    'priority' => 20,
                ),

                // Category
                array(
                    'name' => 'category',
                    'type' => 'taxonomy',
                    'tax' => 'category',
                    'label' => esc_html__( 'Category', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'Display posts from a specific category.', 'lsvr-townpress-toolkit' ),
                    'priority' => 30,
                ),

                // Limit
                array(
                    'name' => 'limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Limit', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'How many posts to display.', 'lsvr-townpress-toolkit' ),
                    'choices' => array( 0 => esc_html__( 'All', 'lsvr-townpress-toolkit' ) ) + range( 0, 20, 1 ),
                    'default' => 4,
                    'priority' => 40,
                ),

                // Featured limit
                array(
                    'name' => 'featured_limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Featured Limit', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'How many posts will be displayed as featured - with excerpt and featured image.', 'lsvr-townpress-toolkit' ),
                    'choices' => range( 0, 15, 1 ),
                    'default' => 1,
                    'priority' => 50,
                ),

                // More Label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Link Label', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'Link to post archive. Leave blank to hide.', 'lsvr-townpress-toolkit' ),
                    'default' => esc_html__( 'More News', 'lsvr-townpress-toolkit' ),
                    'priority' => 60,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-townpress-toolkit' ),
                    'priority' => 70,
                ),

            ), apply_filters( 'lsvr_townpress_posts_shortcode_atts', array() ) );
        }

    }
}
?>