<?php
/**
 * LSVR TownPress Widgets Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Townpress_Sidebar' ) ) {
    class Lsvr_Shortcode_Townpress_Sidebar {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Prepare default atts
            $default_atts = array(
                'sidebar_id' => 'lsvr-townpress-default-sidebar-left',
                'columns_count' => 2,
                'id' => '',
                'className' => '',
                'editor_view' => false,
            );

            // Merge default atts with custom atts
            if ( ! empty( apply_filters( 'lsvr_townpress_sidebar_shortcode_atts', array() ) ) ) {

                $default_atts = array_merge(
                    $default_atts,
                    array_fill_keys( array_column( apply_filters( 'lsvr_townpress_sidebar_shortcode_atts', array() ), 'name' ), '' )
                );

            }

            // Merge default atts and received atts
            $args = shortcode_atts(
                $default_atts,
                $atts
            );

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Element class
            $class_arr = array( 'lsvr-townpress-sidebar' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr-townpress-sidebar--editor-view' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            // Prepare template vars
            global $lsvr_template_vars;
            $lsvr_template_vars = array(
                'args' => $args,
                'class_arr' => $class_arr,
                'editor_view' => $editor_view,
            );

            ob_start();

            // Load template
            if ( function_exists( 'lsvr_framework_load_template' ) ) {
                lsvr_framework_load_template( apply_filters( 'lsvr_shortcode_townpress_sidebar_template_path', 'lsvr-townpress-toolkit/templates/shortcodes/townpress-sidebar.php' ) );
            }

            return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Sidebar ID
                array(
                    'name' => 'sidebar_id',
                    'type' => 'select',
                    'label' => esc_html__( 'Sidebar', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'Choose which sidebar will be used to create this section. You can manage custom sidebars under Customizer / Custom Sidebars and populate them with widgets under Appearance / Widgets.', 'lsvr-townpress-toolkit' ),
                    'choices' => lsvr_townpress_toolkit_get_sidebars(),
                    'priority' => 10,
                ),

                // Columns count
                array(
                    'name' => 'columns_count',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display the widgets.', 'lsvr-townpress-toolkit' ),
                    'choices' => array( 1 => 1, 2 => 2, 3 => 3, 4 => 4 ),
                    'default' => 2,
                    'priority' => 20,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-townpress-toolkit' ),
                    'priority' => 30,
                ),

            ), apply_filters( 'lsvr_townpress_sidebar_shortcode_atts', array() ) );
        }

    }
}
?>