<?php
/**
 * LSVR TownPress Sitemap Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Townpress_Sitemap' ) ) {
    class Lsvr_Shortcode_Townpress_Sitemap {

        public static function shortcode( $atts = array(), $content = null, $tag = '' ) {

            // Prepare default atts
            $default_atts = array(
                'title' => '',
                'icon' => '',
                'menu_id' => '',
                'columns_count' => 3,
                'id' => '',
                'className' => '',
                'editor_view' => false,
            );

            // Merge default atts with custom atts
            if ( ! empty( apply_filters( 'lsvr_townpress_sitemap_shortcode_atts', array() ) ) ) {

                $default_atts = array_merge(
                    $default_atts,
                    array_fill_keys( array_column( apply_filters( 'lsvr_townpress_sitemap_shortcode_atts', array() ), 'name' ), '' )
                );

            }

            // Merge default atts and received atts
            $args = shortcode_atts(
                $default_atts,
                $atts
            );

            // Check if editor view
            $editor_view = true === $args['editor_view'] || '1' === $args['editor_view'] || 'true' === $args['editor_view'] ? true : false;

            // Element class
            $class_arr = array( 'lsvr-townpress-sitemap' );
            if ( true === $editor_view ) {
                array_push( $class_arr, 'lsvr-townpress-sitemap--editor-view' );
            }
            if ( ! empty( $args['className'] ) ) {
                array_push( $class_arr, $args['className'] );
            }

            // Prepare template vars
            global $lsvr_template_vars;
            $lsvr_template_vars = array(
                'args' => $args,
                'class_arr' => $class_arr,
                'editor_view' => $editor_view,
            );

            ob_start();

            // Load template
            if ( function_exists( 'lsvr_framework_load_template' ) ) {
                lsvr_framework_load_template( apply_filters( 'lsvr_shortcode_townpress_sitemap_template_path', 'lsvr-townpress-toolkit/templates/shortcodes/townpress-sitemap.php' ) );
            }

            return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'Title of this section.', 'lsvr-townpress-toolkit' ),
                    'default' => esc_html__( 'Choose Your Interest', 'lsvr-townpress-toolkit' ),
                    'priority' => 10,
                ),

                // Icon
                array(
                    'name' => 'icon',
                    'type' => 'text',
                    'label' => esc_html__( 'Icon', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'Icon name. Please refer to the documentation to learn more about icons.', 'lsvr-townpress-toolkit' ),
                    'default' => 'icon-road-sign',
                    'priority' => 20,
                ),

                // Menu ID
                array(
                    'name' => 'menu_id',
                    'type' => 'menu',
                    'label' => esc_html__( 'Menu', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'Choose which menu will be used to create the sitemap. You can manage menus under Appearance / Menus.', 'lsvr-townpress-toolkit' ),
                    'priority' => 30,
                ),

                // Columns count
                array(
                    'name' => 'columns_count',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display the sitemap.', 'lsvr-townpress-toolkit' ),
                    'choices' => array( 1 => 1 , 2 => 2, 3 => 3, 4 => 4 ),
                    'default' => 3,
                    'priority' => 40,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-townpress-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-townpress-toolkit' ),
                    'priority' => 50,
                ),

            ), apply_filters( 'lsvr_townpress_sitemap_shortcode_atts', array() ) );
        }

    }
}
?>