<?php
/**
 * LSVR Menu widget
 *
 * Display a custom menu
 */
if ( ! class_exists( 'Lsvr_Widget_Townpress_Menu' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Townpress_Menu extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_townpress_menu',
			'classname' => 'lsvr-townpress-menu-widget',
			'title' => esc_html__( 'TownPress Menu', 'lsvr-townpress-toolkit' ),
			'description' => esc_html__( 'Custom menu', 'lsvr-townpress-toolkit' ),
			'fields' => array(
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-townpress-toolkit' ),
					'type' => 'text',
				),
				'menu_id' => array(
					'label' => esc_html__( 'Menu:', 'lsvr-townpress-toolkit' ),
					'description' => esc_html__( 'Choose menu to display. You can manage your menus under Appearance / Menus.', 'lsvr-townpress-toolkit' ),
					'type' => 'select',
					'choices' => lsvr_townpress_toolkit_get_menus(),
				),
				'show_active' => array(
					'label' => esc_html__( 'Expand Active Submenu', 'lsvr-townpress-toolkit' ),
					'description' => esc_html__( 'Active item\'s submenu will be displayed without hovering on desktop devices.', 'lsvr-townpress-toolkit' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'show_on_mobile' => array(
					'label' => esc_html__( 'Display On Mobile', 'lsvr-townpress-toolkit' ),
					'description' => esc_html__( 'Display this menu on mobile devices.', 'lsvr-townpress-toolkit' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
			),
		));

    }

    function widget( $args, $instance ) {

    	// Show active
    	$show_active = ! empty( $instance['show_active'] ) && ( true === $instance['show_active'] || 'true' === $instance['show_active'] || '1' === $instance['show_active'] ) ? true : false;

    	// Show on mobile
		if ( ! empty( $instance['show_on_mobile'] ) && ( true === $instance['show_on_mobile'] || 'true' === $instance['show_on_mobile'] || '1' === $instance['show_on_mobile'] ) ) {
			$args[ 'before_widget' ] = str_replace( 'widget lsvr-townpress-menu-widget', 'widget lsvr-townpress-menu-widget lsvr-townpress-menu-widget--show-on-mobile', $args[ 'before_widget' ] );
		}

		// Get menu object
		if ( ! empty( $instance['menu_id'] ) && is_nav_menu( $instance['menu_id'] ) ) {
			$menu_object = wp_get_nav_menu_object( $instance['menu_id'] );
		}

    	// Prepare template vars
    	global $lsvr_template_vars;
  		$lsvr_template_vars = array(
  			'instance' => $instance,
  			'show_active' => $show_active,
  			'menu_object' => ! empty( $menu_object ) ? $menu_object : '',
		);

        // Before widget content
        parent::before_widget_content( $args, $instance );

        // Load template
        if ( function_exists( 'lsvr_framework_load_template' ) ) {
			lsvr_framework_load_template( apply_filters( 'lsvr_widget_townpress_menu_template_path', 'lsvr-townpress-toolkit/templates/widgets/townpress-menu.php' ) );
		}

        // After widget content
        parent::after_widget_content( $args, $instance );

    }

}}

?>