<?php
/**
 * LSVR Weather widget
 *
 * Display a weather forecast from openweather.org
 */
if ( ! class_exists( 'Lsvr_Widget_Townpress_Weather' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Townpress_Weather extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_townpress_weather',
			'classname' => 'lsvr-townpress-weather-widget',
			'title' => esc_html__( 'TownPress Weather', 'lsvr-townpress-toolkit' ),
			'description' => esc_html__( 'Weather forecast', 'lsvr-townpress-toolkit' ),
			'fields' => array(
				'info' => array(
					'type' => 'info',
					'content' => esc_html__( 'Please insert your OpenWeatherMap.org API Key under Appearance / Customizer / Misc. Also, don\'t forget to set your basic locale settings under Settings / General (especially Timezone).', 'lsvr-townpress-toolkit' ),
				),
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-townpress-toolkit' ),
					'type' => 'text',
					'default' => esc_html__( 'Weather', 'lsvr-townpress-toolkit' ),
				),
				'address' => array(
					'label' => esc_html__( 'Address:', 'lsvr-townpress-toolkit' ),
					'type' => 'text',
					'description' => esc_html__( 'For example: "stowe,us". You can search for your location on openweathermap.org to see if it\'s in the database.', 'lsvr-townpress-toolkit' ),
				),
				'latitude' => array(
					'label' => esc_html__( 'Latitude:', 'lsvr-townpress-toolkit' ),
					'type' => 'text',
					'description' => esc_html__( 'Use if you are unable to get your local weather using just the address.', 'lsvr-townpress-toolkit' ),
				),
				'longitude' => array(
					'label' => esc_html__( 'Longitude:', 'lsvr-townpress-toolkit' ),
					'type' => 'text',
					'description' => esc_html__( 'Use if you are unable to get your local weather using just the address.', 'lsvr-townpress-toolkit' ),
				),
				'forecast_length' => array(
					'label' => esc_html__( 'Forecast Length:', 'lsvr-townpress-toolkit' ),
					'type' => 'select',
					'description' => esc_html__( 'How many days of forecast will be displayed.', 'lsvr-townpress-toolkit' ),
					'choices' => array(
						'0' => esc_html__( 'No forecast', 'lsvr-townpress-toolkit' ),
						'1' => esc_html__( '1 day', 'lsvr-townpress-toolkit' ),
						'2' => esc_html__( '2 days', 'lsvr-townpress-toolkit' ),
						'3' => esc_html__( '3 days', 'lsvr-townpress-toolkit' ),
					),
					'default' => '3',
				),
				'units_format' => array(
					'label' => esc_html__( 'Units Format:', 'lsvr-townpress-toolkit' ),
					'type' => 'select',
					'choices' => array(
						'metric' => esc_html__( 'Metric', 'lsvr-townpress-toolkit' ),
						'imperial' => esc_html__( 'Imperial', 'lsvr-townpress-toolkit' ),
					),
					'default' => 'metric',
				),
				'update_interval' => array(
					'label' => esc_html__( 'Update Interval:', 'lsvr-townpress-toolkit' ),
					'type' => 'select',
					'description' => esc_html__( 'How often should be weather data pulled from openweathermap.org.', 'lsvr-townpress-toolkit' ),
					'choices' => array(
						'10min' => esc_html__( 'Every 10 minutes', 'lsvr-townpress-toolkit' ),
						'30min' => esc_html__( 'Every 30 minutes', 'lsvr-townpress-toolkit' ),
						'1hour' => esc_html__( 'Every hour', 'lsvr-townpress-toolkit' ),
						'3hours' => esc_html__( 'Every 3 hours', 'lsvr-townpress-toolkit' ),
						'12hours' => esc_html__( 'Every 12 hours', 'lsvr-townpress-toolkit' ),
						'24hours' => esc_html__( 'Every 24 hours', 'lsvr-townpress-toolkit' ),
						'disable' => esc_html__( 'On each page load (not recommended)', 'lsvr-townpress-toolkit' ),
					),
					'default' => '1hour',
				),
				'show_time' => array(
					'label' => esc_html__( 'Show Local Time', 'lsvr-townpress-toolkit' ),
					'description' => esc_html__( 'You can change your Timezone and Time Format under Settings / General.', 'lsvr-townpress-toolkit' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'background_image' => array(
					'label' => esc_html__( 'Background Image:', 'lsvr-townpress-toolkit' ),
					'description' => esc_html__( 'Optimal resolution is about 600x600px.', 'lsvr-townpress-toolkit' ),
					'type' => 'image',
				),
				'bottom_text' => array(
					'label' => esc_html__( 'Bottom Text:', 'lsvr-townpress-toolkit' ),
					'description' => esc_html__( 'Custom text which will be displayed at the bottom of the widget content.', 'lsvr-townpress-toolkit' ),
					'type' => 'textarea',
				),
			),
		));

    }

    function widget( $args, $instance ) {

    	// Check if editor view
        $editor_view = ! empty( $instance['editor_view'] ) && ( true === $instance['editor_view'] || '1' === $instance['editor_view'] || 'true' === $instance['editor_view'] ) ? true : false;

    	// Show time
    	$show_time = ! empty( $instance['show_time'] ) && ( true === $instance['show_time'] || 'true' === $instance['show_time'] || '1' === $instance['show_time'] ) ? true : false;

        // Background image
        if ( ! empty( $instance['background_image'] ) && is_numeric( $instance['background_image'] ) && (int) $instance['background_image'] > 0 ) {

            $image_data = wp_get_attachment_image_src( (int) $instance['background_image'], 'full' );
            if ( ! empty( $image_data[0] ) ) {
                $background_url = $image_data[0];
            }

        } elseif ( ! empty( $instance['background_image'] ) ) {
            $background_url = $instance['background_image'];
        }

		if ( ! empty( $background_url ) ) {
			$args[ 'before_widget' ] = str_replace( 'lsvr-townpress-weather-widget', 'lsvr-townpress-weather-widget lsvr-townpress-weather-widget--has-background', $args[ 'before_widget' ] );
			$args[ 'before_widget' ] = str_replace( 'widget__inner"', 'widget__inner" style="background-image: url(' . esc_url( $background_url ) . ');"', $args[ 'before_widget' ] );
		}

		// Prepare ajax query
		$ajax_params = array(
			'address' => ! empty( $instance['address'] ) ? $instance['address'] : '',
			'latitude' => ! empty( $instance['latitude'] ) ? $instance['latitude'] : '',
			'longitude' => ! empty( $instance['longitude'] ) ? $instance['longitude'] : '',
			'forecast_length' => ! empty( $instance['forecast_length'] ) ? intval( $instance['forecast_length'] ) : 0,
			'units_format' => ! empty( $instance['units_format'] ) ? $instance['units_format'] : 'metric',
			'update_interval' => ! empty( $instance['update_interval'] ) ? $instance['update_interval'] : '1hour',
		);

		if ( ! empty( $ajax_params['address'] ) || ( ! empty( $ajax_params['latitude'] ) && ! empty( $ajax_params['longitude'] ) ) ) {
			$ajax_params_json = json_encode( $ajax_params );
		} else {
			$ajax_params_json = false;
		}

    	// Prepare template vars
    	global $lsvr_template_vars;
  		$lsvr_template_vars = array(
  			'instance' => $instance,
  			'show_time' => $show_time,
  			'editor_view' => $editor_view,
  			'background_url' => ! empty( $background_url ) ? $background_url : '',
  			'ajax_params' => $ajax_params,
  			'ajax_params_json' => $ajax_params_json,
		);

		// Before widget content
        parent::before_widget_content( $args, $instance );

        // Load template
        if ( function_exists( 'lsvr_framework_load_template' ) ) {
			lsvr_framework_load_template( apply_filters( 'lsvr_widget_townpress_weather_template_path', 'lsvr-townpress-toolkit/templates/widgets/townpress-weather.php' ) );
		}

        // After widget content
        parent::after_widget_content( $args, $instance );

    }

}}

?>