<?php global $lsvr_template_vars;
if ( ! empty( $lsvr_template_vars ) && is_array( $lsvr_template_vars ) ) : extract( $lsvr_template_vars );

// TEMPLATE : BEGIN ?>

<!-- TOWNPRESS POST SLIDER : begin -->
<div class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
    data-autoplay="<?php echo ! empty( $args['autoplay'] ) ? esc_attr( (int) $args['autoplay'] ) : 0; ?>"
    <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
    <div class="lsvr-townpress-post-slider__inner"<?php if ( ! empty( $args['height'] ) && (int) $args['height'] > 0 ) { echo ' style=" height: ' . esc_attr( (int) $args['height'] ) . 'px;"'; } ?>>

        <?php if ( ! empty( $blog_posts ) ) : ?>

            <div class="lsvr-townpress-post-slider__list">

                <?php foreach ( $blog_posts as $blog_post ) : ?>

                    <article <?php post_class( 'lsvr-townpress-post-slider__post', $blog_post->ID ); ?>>
                        <div class="lsvr-townpress-post-slider__post-bg"
                            <?php if ( has_post_thumbnail( $blog_post->ID ) ) { echo ' style="background-image: url( ' . esc_url( get_the_post_thumbnail_url( $blog_post->ID, 'full' ) ) . ' );"'; } ?>>
                            <div class="lsvr-townpress-post-slider__post-inner"<?php if ( ! empty( $args['height'] ) && (int) $args['height'] > 0 ) { echo ' style=" height: ' . esc_attr( (int) $args['height'] ) . 'px;"'; } ?>>

                                <header class="lsvr-townpress-post-slider__post-header">

                                    <h2 class="lsvr-townpress-post-slider__post-title">
                                        <a href="<?php echo esc_url( get_the_permalink( $blog_post->ID ) ); ?>"
                                            class="lsvr-townpress-post-slider__post-title-link" rel="bookmark">
                                            <?php echo esc_html( $blog_post->post_title ); ?>
                                        </a>
                                    </h2>

                                    <p class="lsvr-townpress-post-slider__post-meta">
                                        <time class="lsvr-townpress-post-slider__post-meta-date"
                                            datetime="<?php echo esc_attr( get_the_time( 'c', $blog_post->ID  ) ); ?>">
                                            <?php echo esc_html( get_the_date( get_option( 'date_format' ), $blog_post->ID ) ); ?>
                                        </time>
                                        <span class="lsvr-townpress-post-slider__post-meta-categories">
                                            <?php lsvr_townpress_toolkit_the_post_terms( $blog_post->ID, 'category', esc_html__( 'in %s', 'lsvr-townpress-toolkit' ), '',  1 ); ?>
                                        </span>
                                    </p>

                                </header>

                                <?php if ( true === $show_excerpt && ! empty( $blog_post->post_excerpt ) ) : ?>

                                    <div class="lsvr-townpress-post-slider__post-content">
                                        <?php echo wpautop( wp_kses( $blog_post->post_excerpt, array(
                                            'a' => array(
                                                'href' => array()
                                            ),
                                            'strong' => array(),
                                            'em' => array(),
                                            'br' => array(),
                                        ) ) ); ?>
                                    </div>

                                <?php endif; ?>

                                <a href="<?php echo esc_url( get_the_permalink( $blog_post->ID ) ); ?>"
                                    style="opacity: <?php echo ! empty( $args['overlay_opacity'] ) ? esc_attr( (int) $args['overlay_opacity'] / 100 ) : 0.5; ?>"
                                    class="lsvr-townpress-post-slider__post-overlay-link">
                                    <span class="screen-reader-text"><?php esc_html_e( 'Read More', 'lsvr-townpress-toolkit' ); ?></span>
                                </a>

                            </div>
                        </div>
                    </article>

                <?php endforeach; wp_reset_postdata(); ?>

            </div>

            <?php if ( ! empty( $args['autoplay'] ) && (int) $args['autoplay'] > 0 ) : ?>

                <div class="lsvr-townpress-post-slider__indicator"><span class="lsvr-townpress-post-slider__indicator-inner"></span></div>

            <?php endif; ?>

        <?php else : ?>

            <p class="c-alert-message"><?php esc_html_e( 'There are no posts', 'lsvr-townpress-toolkit' ); ?></p>

        <?php endif; ?>

    </div>
</div>
<!-- TOWNPRESS POST SLIDER : end -->

<?php // TEMPLATE : END
endif; ?>