<?php global $lsvr_template_vars;
if ( ! empty( $lsvr_template_vars ) && is_array( $lsvr_template_vars ) ) : extract( $lsvr_template_vars );

// TEMPLATE : BEGIN ?>

<!-- TOWNPRESS POSTS : begin -->
<section class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
    <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
    <div class="c-content-box lsvr-townpress-posts__inner">

        <?php if ( ! empty( $args['icon'] ) ) : ?>
            <span class="lsvr-townpress-posts__icon <?php echo esc_html( $args['icon'] ); ?>"
                aria-hidden="true"></span>
        <?php endif; ?>

        <?php if ( ! empty( $args['title'] ) ) : ?>

            <header class="lsvr-townpress-posts__header">
                <h2 class="lsvr-townpress-posts__title<?php if ( ! empty( $args['icon'] ) ) { echo ' lsvr-townpress-posts__title--has-icon'; } ?>">

                    <?php if ( ! empty( $args['icon'] ) ) : ?>
                        <span class="lsvr-townpress-posts__title-icon <?php echo esc_html( $args['icon'] ); ?>"
                            aria-hidden="true"></span>
                    <?php endif; ?>

                    <?php if ( ! empty( $category_id ) && ! empty( term_exists( $category_id, 'category' ) ) ) : ?>

                        <a href="<?php echo esc_url( get_term_link( (int) $category_id, 'category' ) ); ?>"
                            class="lsvr-townpress-posts__title-link">

                    <?php else : ?>

                        <a href="<?php echo esc_url( get_post_type_archive_link( 'post' ) ); ?>"
                            class="lsvr-townpress-posts__title-link">

                    <?php endif; ?>

                        <?php echo wp_kses( $args['title'], array(
                            'strong' => array(),
                        )); ?>

                    </a>

                </h2>
            </header>

        <?php endif; ?>

        <div class="lsvr-townpress-posts__content">

            <?php if ( ! empty( $blog_posts ) ) : ?>

                <ul class="lsvr-townpress-posts__list">

                    <?php $i = 0; foreach ( $blog_posts as $blog_post ) : ?>

                        <?php // Featured post
                        if ( ! empty( $args['featured_limit'] ) && $i < (int) $args['featured_limit'] ) : ?>

                            <li class="lsvr-townpress-posts__item lsvr-townpress-posts__item--featured<?php if ( has_post_thumbnail( $blog_post->ID ) ) { echo ' lsvr-townpress-posts__item--has-thumbnail'; } ?>">

                                <article <?php post_class( 'lsvr-townpress-posts__post', $blog_post->ID ); ?>>
                                    <div class="lsvr-townpress-posts__post-inner">

                                        <header class="lsvr-townpress-posts__post-header">

                                            <?php if ( has_post_thumbnail( $blog_post->ID ) ) : ?>

                                                <p class="lsvr-townpress-posts__post-thumbnail">
                                                    <a href="<?php echo esc_url( get_the_permalink( $blog_post->ID ) ); ?>"
                                                        class="lsvr-townpress-posts__post-thumbnail-link"
                                                        style="background-image: url( '<?php echo esc_url( get_the_post_thumbnail_url( $blog_post->ID, 'full' ) ); ?>' );">

                                                        <?php if ( ! empty( lsvr_townpress_toolkit_get_image_alt( get_post_thumbnail_id( $blog_post->ID ) ) ) ) : ?>

                                                            <span class="screen-reader-text"><?php echo esc_html( lsvr_townpress_toolkit_get_image_alt( get_post_thumbnail_id( $blog_post->ID ) ) ); ?></span>

                                                        <?php endif; ?>

                                                    </a>
                                                </p>

                                            <?php endif; ?>

                                            <h3 class="lsvr-townpress-posts__post-title">
                                                <a href="<?php echo esc_url( get_the_permalink( $blog_post->ID ) ); ?>" class="lsvr-townpress-posts__post-title-link" rel="bookmark">
                                                    <?php echo esc_html( $blog_post->post_title ); ?>
                                                </a>
                                            </h3>

                                            <p class="lsvr-townpress-posts__post-meta">

                                                <span class="lsvr-townpress-posts__post-meta-date" role="group">
                                                    <?php echo esc_html( get_the_date( get_option( 'date_format' ), $blog_post->ID ) ); ?>
                                                </span>

                                                <span class="lsvr-townpress-posts__post-meta-categories" role="group">
                                                    <?php lsvr_townpress_toolkit_the_post_terms( $blog_post->ID, 'category', esc_html__( 'in %s', 'lsvr-townpress-toolkit' ), '',  1 ); ?>
                                                </span>

                                            </p>

                                        </header>

                                        <div class="lsvr-townpress-posts__post-content">

                                            <?php if ( ! empty( $blog_post->post_excerpt ) ) : ?>

                                                <?php echo wpautop( wp_kses( $blog_post->post_excerpt, array(
                                                    'a' => array(
                                                        'href' => array()
                                                    ),
                                                    'strong' => array(),
                                                    'em' => array(),
                                                    'br' => array(),
                                                ) ) ); ?>

                                                <p class="lsvr-townpress-posts__post-permalink">
                                                    <a href="<?php echo esc_url( get_permalink( $blog_post->ID ) ); ?>" class="lsvr-townpress-posts__post-permalink-link" rel="bookmark">
                                                        <?php esc_html_e( 'Read More', 'lsvr-townpress-toolkit' ); ?>
                                                    </a>
                                                </p>

                                            <?php elseif ( $blog_post->post_content ) : ?>

                                                <?php echo has_blocks( $blog_post->ID ) ? $blog_post->post_content : wpautop( $blog_post->post_content ); ?>

                                            <?php endif; ?>

                                        </div>

                                    </div>
                                </article>

                            </li>

                        <?php // Shortformat post
                        else : ?>

                            <li class="lsvr-townpress-posts__item lsvr-townpress-posts__item--short">

                                <article <?php post_class( 'lsvr-townpress-posts__post', $blog_post->ID ); ?>>

                                    <h3 class="lsvr-townpress-posts__post-title">
                                        <a href="<?php echo esc_url( get_the_permalink( $blog_post->ID ) ); ?>" class="lsvr-townpress-posts__post-title-link" rel="bookmark">
                                            <?php echo esc_html( $blog_post->post_title ); ?>
                                        </a>
                                    </h3>

                                    <p class="lsvr-townpress-posts__post-meta">
                                        <span class="lsvr-townpress-posts__post-meta-date">
                                            <?php echo esc_html( get_the_date( get_option( 'date_format' ), $blog_post->ID ) ); ?>
                                        </span>
                                    </p>

                                </article>

                            </li>

                        <?php endif; ?>

                    <?php $i++; endforeach; wp_reset_postdata(); ?>

                </ul>

            <?php else : ?>

                <p class="c-alert-message"><?php esc_html_e( 'There are no posts', 'lsvr-townpress-toolkit' ); ?></p>

            <?php endif; ?>

        </div>

        <?php if ( ! empty( $args[ 'more_label' ] ) ) : ?>

            <footer class="lsvr-townpress-posts__footer">

                <p class="lsvr-townpress-posts__more">

                    <?php if ( ! empty( $category_id ) && ! empty( term_exists( $category_id, 'category' ) ) ) : ?>

                        <a href="<?php echo esc_url( get_term_link( (int) $category_id, 'category' ) ); ?>"
                            class="lsvr-townpress-posts__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>

                    <?php else : ?>

                        <a href="<?php echo esc_url( get_post_type_archive_link( 'post' ) ); ?>"
                            class="lsvr-townpress-posts__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>

                    <?php endif; ?>

                </p>

            </footer>

        <?php endif; ?>

    </div>
</section>
<!-- TOWNPRESS POSTS : end -->

<?php // TEMPLATE : END
endif; ?>