<?php global $lsvr_template_vars;
if ( ! empty( $lsvr_template_vars ) && is_array( $lsvr_template_vars ) ) : extract( $lsvr_template_vars );

// TEMPLATE : BEGIN ?>

<!-- TOWNPRESS SITEMAP : begin -->
<section class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
    <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
    <div class="c-content-box lsvr-townpress-sitemap__inner">

        <?php if ( ! empty( $args['icon'] ) ) : ?>
            <span class="lsvr-townpress-sitemap__icon <?php echo esc_html( $args['icon'] ); ?>"
                aria-hidden="true"></span>
        <?php endif; ?>

        <?php if ( ! empty( $args['title'] ) ) : ?>

            <header class="lsvr-townpress-sitemap__header">
                <h2 class="lsvr-townpress-sitemap__title<?php if ( ! empty( $args['icon'] ) ) { echo ' lsvr-townpress-sitemap__title--has-icon'; } ?>">

                    <?php if ( ! empty( $args['icon'] ) ) : ?>
                        <span class="lsvr-townpress-sitemap__title-icon <?php echo esc_html( $args['icon'] ); ?>"
                            aria-hidden="true"></span>
                    <?php endif; ?>

                    <?php echo wp_kses( $args['title'], array(
                        'strong' => array(),
                    )); ?>

                </h2>
            </header>

        <?php endif; ?>

        <?php if ( ! empty( $args['menu_id'] ) && class_exists( 'Lsvr_Townpress_Sitemap_Walker' ) ) : ?>

            <div class="lsvr-townpress-sitemap__content">
                <nav class="lsvr-townpress-sitemap__nav lsvr-townpress-sitemap__nav--<?php echo ! empty( $args['columns_count'] ) ? esc_attr( $args['columns_count'] ) : 3; ?>-cols"
                    <?php if ( ! empty( $args['title'] ) ) : ?>
                        aria-label="<?php echo esc_attr( $args['title'] ); ?>"
                    <?php endif; ?>>

                    <?php wp_nav_menu(array(
                        'menu' => $args['menu_id'],
                        'container' => '',
                        'menu_class' => 'lsvr-townpress-sitemap__list',
                        'fallback_cb' => '',
                        'items_wrap' => '<ul id="%1$s" class="%2$s" role="menu">%3$s</ul>',
                        'walker' => new Lsvr_Townpress_Sitemap_Walker,
                    )); ?>

                </nav>
            </div>

        <?php else : ?>

            <p class="c-alert-message lsvr-townpress-sitemap__message">
                <?php esc_html_e( 'Please choose which menu will be used to create this sitemap.', 'lsvr-townpress-toolkit' ); ?>
            </p>

        <?php endif; ?>

    </div>
</section>
<!-- TOWNPRESS SITEMAP : end -->

<?php // TEMPLATE : END
endif; ?>