<?php global $lsvr_template_vars;
if ( ! empty( $lsvr_template_vars ) && is_array( $lsvr_template_vars ) ) : extract( $lsvr_template_vars );

// TEMPLATE : BEGIN ?>

<div class="widget__content">

	<?php // Local time
	if ( true === $show_time ) : ?>

		<div class="lsvr-townpress-weather-widget__time">
			<h4 class="lsvr-townpress-weather-widget__time-title"><?php esc_html_e( 'Local Time', 'lsvr-townpress-toolkit' ); ?></h4>
			<p class="lsvr-townpress-weather-widget__time-value"
				data-timezone="<?php echo esc_attr( get_option( 'timezone_string' ) ); ?>">
				<?php echo current_time( get_option( 'time_format' ) ); ?>
			</p>
		</div>

	<?php endif; ?>

	<?php // Weather
	if ( ! empty( $ajax_params_json ) && false === $editor_view ) : ?>

		<div class="lsvr-townpress-weather-widget__weather lsvr-townpress-weather-widget__weather--loading"
			data-ajax-params="<?php echo esc_attr( $ajax_params_json ); ?>"
			data-forecast-length="<?php echo esc_attr( $ajax_params['forecast_length'] ); ?>">

			<span class="lsvr-townpress-weather-widget__weather-spinner c-spinner"></span>

			<ul class="lsvr-townpress-weather-widget__weather-list" style="display: none;">

				<li class="lsvr-townpress-weather-widget__weather-item lsvr-townpress-weather-widget__weather-item--current">

					<div class="lsvr-townpress-weather-widget__weather-item-labels">
						<h4 class="lsvr-townpress-weather-widget__weather-item-title">
							<?php esc_html_e( 'Today', 'lsvr-townpress-toolkit' ); ?>
						</h4>
						<h5 class="lsvr-townpress-weather-widget__weather-item-date">
							<?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( current_time( 'mysql' ) ) ) ); ?>
						</h5>
					</div>

					<div class="lsvr-townpress-weather-widget__weather-item-values">
						<span class="lsvr-townpress-weather-widget__weather-item-icon" aria-hidden="true"></span>
						<div class="lsvr-townpress-weather-widget__weather-item-temperature"
							title="<?php echo esc_attr( esc_html__( 'Temperature', 'lsvr-townpress-toolkit' ) ); ?>">
							<?php echo 'metric' === $ajax_params['units_format'] ? esc_html__( '&deg;C', 'lsvr-townpress-toolkit' ) : esc_html__( '&deg;F', 'lsvr-townpress-toolkit' ); ?>
						</div>
						<div class="lsvr-townpress-weather-widget__weather-item-wind"
							title="<?php echo esc_attr( esc_html__( 'Wind speed', 'lsvr-townpress-toolkit' ) ); ?>">
							<?php echo 'metric' === $ajax_params['units_format'] ? esc_html__( 'm/s', 'lsvr-townpress-toolkit' ) : esc_html__( 'm/h', 'lsvr-townpress-toolkit' ); ?>
						</div>
					</div>

				</li>

				<?php for ( $i = 1; $i <= $ajax_params['forecast_length']; $i++ ) : ?>

					<li class="lsvr-townpress-weather-widget__weather-item lsvr-townpress-weather-widget__weather-item--forecast lsvr-townpress-weather-widget__weather-item--forecast-<?php echo esc_attr( $i ); ?>"
							data-timestamp="<?php echo esc_attr( strtotime( current_time( 'Y-m-d 12:00:00' ) ) + ( 60 * 60 * ( 24 * ( $i ) ) ) ); ?>">

						<div class="lsvr-townpress-weather-widget__weather-item-labels">
							<h4 class="lsvr-townpress-weather-widget__weather-item-title">
								<?php echo date_i18n( 'l', strtotime( current_time( 'mysql' ) ) + ( 60 * 60 * ( 24 * ( $i ) ) ) ); ?>
							</h4>
							<h5 class="lsvr-townpress-weather-widget__weather-item-date">
								<?php echo date_i18n( get_option( 'date_format' ), strtotime( current_time( 'mysql' ) ) + ( 60 * 60 * ( 24 * ( $i ) ) ) ); ?>
							</h5>
						</div>

						<div class="lsvr-townpress-weather-widget__weather-item-values">
							<span class="lsvr-townpress-weather-widget__weather-item-icon" aria-hidden="true"></span>
							<div class="lsvr-townpress-weather-widget__weather-item-temperature"
								title="<?php echo esc_attr( esc_html__( 'Temperature', 'lsvr-townpress-toolkit' ) ); ?>">
								<?php echo 'metric' === $ajax_params['units_format'] ? esc_html__( '&deg;C', 'lsvr-townpress-toolkit' ) : esc_html__( '&deg;F', 'lsvr-townpress-toolkit' ); ?>
							</div>
							<div class="lsvr-townpress-weather-widget__weather-item-wind"
								title="<?php echo esc_attr( esc_html__( 'Wind speed', 'lsvr-townpress-toolkit' ) ); ?>">
								<?php echo 'metric' === $ajax_params['units_format'] ? esc_html__( 'm/s', 'lsvr-townpress-toolkit' ) : esc_html__( 'm/h', 'lsvr-townpress-toolkit' ); ?>
							</div>
						</div>

					</li>

				<?php endfor; ?>

			</ul>

		</div>

	<?php elseif ( true === $editor_view ) :  ?>

        <p class="c-alert-message lsvr-townpress-weather-widget__message">
            <?php esc_html_e( 'Weather forecast can be displayed on front-end only.', 'lsvr-townpress-toolkit' ); ?>
        </p>

	<?php endif; ?>

	<?php // Bottom text
	if ( ! empty( $instance['bottom_text'] ) ) : ?>

		<div class="lsvr-townpress-weather-widget__text">
			<?php echo wpautop( wp_kses( $instance['bottom_text'], array(
				'a' => array(
					'href' => array(),
					'title' => array(),
					'target' => array(),
				),
				'em' => array(),
				'br' => array(),
				'strong' => array(),
				'p' => array(),
			))); ?>
		</div>

	<?php endif; ?>

</div>

<?php // TEMPLATE : END
endif; ?>