<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta http-equiv="Content-Type" content="<?php bloginfo( 'html_type' ); ?>; charset=<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php wp_body_open(); ?>

	<?php // Add custom code before wrapper
	do_action( 'lsvr_townpress_wrapper_before' ); ?>

	<!-- WRAPPER : begin -->
	<div id="wrapper">

		<?php // Add custom code at the top of wrapper
		do_action( 'lsvr_townpress_wrapper_top' ); ?>

		<?php // Accessibility links
		get_template_part( 'template-parts/accessibility-links' ); ?>

		<?php // Add custom code before header
		do_action( 'lsvr_townpress_header_before' ); ?>

		<!-- HEADER : begin -->
		<header id="header" <?php lsvr_townpress_the_header_class(); ?>>
			<div class="header__inner">

				<?php // Add custom code at the top of header
				do_action( 'lsvr_townpress_header_top' ); ?>

				<?php // Header navbar
				get_template_part( 'template-parts/header/navbar' ); ?>

				<?php // Add custom code before header map
				do_action( 'lsvr_townpress_header_map_before' ); ?>

				<?php // Header map
				get_template_part( 'template-parts/header/map' ); ?>

				<?php // Add custom code before header content
				do_action( 'lsvr_townpress_header_content_before' ); ?>

				<!-- HEADER CONTENT : begin -->
				<div class="header__content">
					<div class="lsvr-container">
						<div class="header__content-inner">

							<?php // Add custom code at the top of header content
							do_action( 'lsvr_townpress_header_content_top' ); ?>

							<?php // Header branding
							get_template_part( 'template-parts/header/branding' ); ?>

							<?php // Add custom code before header toolbar
							do_action( 'lsvr_townpress_header_toolbar_before' ); ?>

							<?php // Header toolbar
							get_template_part( 'template-parts/header/toolbar' ); ?>

							<?php // Add custom code at the bottom of header content
							do_action( 'lsvr_townpress_header_content_bottom' ); ?>

						</div>
					</div>
				</div>
				<!-- HEADER CONTENT : end -->

				<?php // Add custom code at the bottom of header
				do_action( 'lsvr_townpress_header_bottom' ); ?>

			</div>
		</header>
		<!-- HEADER : end -->

		<?php // Add custom code after header
		do_action( 'lsvr_townpress_header_after' ); ?>

		<?php // Header background
		get_template_part( 'template-parts/header/background' ); ?>

		<?php // Add custom code before core
		do_action( 'lsvr_townpress_core_before' ); ?>

		<!-- CORE : begin -->
		<div id="core">
			<div class="core__inner">