<?php

/**
 * GENERAL
 */

	// Get post category taxonomy
	add_filter( 'lsvr_townpress_post_category_taxonomy', 'lsvr_townpress_blog_category_taxonomy' );
	if ( ! function_exists( 'lsvr_townpress_blog_category_taxonomy' ) ) {
		function lsvr_townpress_blog_category_taxonomy( $taxonomy ) {

			if ( lsvr_townpress_is_blog() ) {
				return 'category';
			}

			return $taxonomy;

		}
	}

	// Get post tag taxonomy
	add_filter( 'lsvr_townpress_post_tag_taxonomy', 'lsvr_townpress_blog_tag_taxonomy' );
	if ( ! function_exists( 'lsvr_townpress_blog_tag_taxonomy' ) ) {
		function lsvr_townpress_blog_tag_taxonomy( $taxonomy ) {

			if ( lsvr_townpress_is_blog() ) {
				return 'post_tag';
			}

			return $taxonomy;

		}
	}

	// Enable improved accesibility
	add_filter( 'body_class', 'lsvr_townpress_improved_accessibility_enabled' );
	if ( ! function_exists( 'lsvr_townpress_improved_accessibility_enabled' ) ) {
		function lsvr_townpress_improved_accessibility_enabled( $class ) {

			if ( true === get_theme_mod( 'improved_accessibility_enable', true ) ) {
				$class[] = 'lsvr-accessibility';
			}

			return $class;

		}
	}

	// Load Google Fonts
	add_action( 'lsvr_townpress_load_assets', 'lsvr_townpress_load_google_fonts_css', 10, 2 );
	if ( ! function_exists( 'lsvr_townpress_load_google_fonts_css' ) ) {
		function lsvr_townpress_load_google_fonts_css() {

			if ( true === get_theme_mod( 'typography_google_fonts_enable', true ) ) {

				// Prepare query params
				$primary_font = get_theme_mod( 'typography_primary_font', 'Source+Sans+Pro' );
				$primary_font_variants = '400,400italic,600,600italic,700,700italic';
				$family_param = $primary_font . ':' . $primary_font_variants;
				$subset = get_theme_mod( 'typography_font_subsets' );
				$subset_param = ! empty( $subset ) && is_string( $subset ) ? $subset : '';

				// Create query
				$query_args = array(
					'family' => $family_param,
					'subset' => $subset_param,
				);
				$query_args = array_filter( $query_args );

				// Enqueue fonts
				if ( ! empty( $query_args ) ) {
					wp_enqueue_style( 'lsvr-townpress-google-fonts', add_query_arg( $query_args, '//fonts.googleapis.com/css' ) );
				}

				// Primary font style
				$primary_font_elements = array( 'body', 'input', 'textarea', 'select', 'button', '#cancel-comment-reply-link', '.lsvr_listing-map__infobox' );
				$primary_font_family = str_replace( '+', ' ', $primary_font );
				$primary_font_css = implode( ', ', $primary_font_elements ) . ' { font-family: \'' . esc_attr( $primary_font_family ) . '\', Arial, sans-serif; }';
				wp_add_inline_style( 'lsvr-townpress-general-style', $primary_font_css );
				wp_add_inline_style( 'lsvr-townpress-general-style', 'html, body { font-size: ' . esc_attr( get_theme_mod( 'typography_base_font_size', '16' ) ) . 'px; }' );

			}

		}
	}

	// Load editor Google Fonts
	add_action( 'lsvr_townpress_load_editor_assets', 'lsvr_townpress_load_editor_google_fonts_css', 10, 2 );
	if ( ! function_exists( 'lsvr_townpress_load_editor_google_fonts_css' ) ) {
		function lsvr_townpress_load_editor_google_fonts_css() {

			if ( true === get_theme_mod( 'typography_google_fonts_enable', true ) ) {

				// Prepare query params
				$primary_font = get_theme_mod( 'typography_primary_font', 'Source+Sans+Pro' );
				$primary_font_variants = '400,400italic,600,600italic,700,700italic';
				$family_param = $primary_font . ':' . $primary_font_variants;
				$subset = get_theme_mod( 'typography_font_subsets' );
				$subset_param = ! empty( $subset ) && is_string( $subset ) ? $subset : '';

				// Create query
				$query_args = array(
					'family' => $family_param,
					'subset' => $subset_param,
				);
				$query_args = array_filter( $query_args );

				// Enqueue fonts
				if ( ! empty( $query_args ) ) {
					wp_enqueue_style( 'lsvr-townpress-editor-google-fonts', add_query_arg( $query_args, '//fonts.googleapis.com/css' ) );
				}

				// Primary font style
				$primary_font_elements = array( '.lsvr-shortcode-block-view__html' );
				$primary_font_family = str_replace( '+', ' ', $primary_font );
				$primary_font_css = implode( ', ', $primary_font_elements ) . ' { font-family: \'' . esc_attr( $primary_font_family ) . '\', Arial, sans-serif; }';
				wp_add_inline_style( 'lsvr-townpress-editor-style', $primary_font_css );
				wp_add_inline_style( 'lsvr-townpress-editor-style', '.lsvr-shortcode-block-view__html { font-size: ' . esc_attr( get_theme_mod( 'typography_base_font_size', '16' ) ) . 'px; }' );

			}

		}
	}

	// Set logo dimensions
	add_action( 'lsvr_townpress_load_assets', 'lsvr_townpress_set_logo_dimensions', 10, 2 );
	if ( ! function_exists( 'lsvr_townpress_set_logo_dimensions' ) ) {
		function lsvr_townpress_set_logo_dimensions() {

			$max_width = get_theme_mod( 'header_logo_max_width', 140 );
			$max_width_home = get_theme_mod( 'header_logo_max_width_home', 200 );
			$max_width_mobile = get_theme_mod( 'header_logo_max_width_mobile', 140 );
			if ( ! empty( $max_width ) && ! empty( $max_width_home ) ) {
				wp_add_inline_style( 'lsvr-townpress-general-style', '.header-logo { max-width: ' . esc_attr( $max_width ) . 'px; } .header-logo--front { max-width: ' . esc_attr( $max_width_home ) . 'px; } @media ( max-width: 991px ) { .header-logo { max-width: ' . esc_attr( $max_width_mobile ) . 'px; } }' );
			}

		}
	}

	// Load skin CSS
	add_action( 'lsvr_townpress_load_assets', 'lsvr_townpress_load_skin_css' );
	if ( ! function_exists( 'lsvr_townpress_load_skin_css' ) ) {
		function lsvr_townpress_load_skin_css() {

			$version = wp_get_theme( 'townpress' );
			$version = $version->Version;

			// Load predefined color skin
			if ( 'predefined' === get_theme_mod( 'colors_method', 'predefined' ) || 'custom-colors' === get_theme_mod( 'colors_method', 'predefined' ) ) {
				$skin_file = get_theme_mod( 'colors_predefined_skin', 'default' );
				wp_enqueue_style( 'lsvr-townpress-color-scheme', get_template_directory_uri() . '/assets/css/skins/' . esc_attr( $skin_file ) . '.css', array( 'lsvr-townpress-general-style' ), $version );
			}

			// Generate CSS from custom colors
			if ( 'custom-colors' === get_theme_mod( 'colors_method', 'predefined' ) ) {
				wp_add_inline_style( 'lsvr-townpress-color-scheme', lsvr_townpress_get_custom_colors_css() );
			}

		}
	}

	// Load editor skin CSS
	add_action( 'lsvr_townpress_load_editor_assets', 'lsvr_townpress_load_editor_skin_css' );
	if ( ! function_exists( 'lsvr_townpress_load_editor_skin_css' ) ) {
		function lsvr_townpress_load_editor_skin_css() {

			$version = wp_get_theme( 'townpress' );
			$version = $version->Version;

			// Load predefined editor color skin
			if ( 'predefined' === get_theme_mod( 'colors_method', 'predefined' ) || 'custom-colors' === get_theme_mod( 'colors_method', 'predefined' ) ) {
				$skin_file = get_theme_mod( 'colors_predefined_skin', 'default' );
				wp_enqueue_style( 'lsvr-townpress-editor-color-scheme', get_template_directory_uri() . '/assets/css/skins/' . esc_attr( $skin_file ) . '.editor.css', array( 'lsvr-townpress-editor-style' ), $version );
			}

			// Generate CSS from custom colors
			if ( 'custom-colors' === get_theme_mod( 'colors_method', 'predefined' ) ) {
				wp_add_inline_style( 'lsvr-townpress-editor-color-scheme', lsvr_townpress_get_custom_colors_css( true ) );
			}


		}
	}

	// Load Google API key
	add_action( 'lsvr_townpress_load_assets', 'lsvr_townpress_load_google_api_key', 10, 2 );
	if ( ! function_exists( 'lsvr_townpress_load_google_api_key' ) ) {
		function lsvr_townpress_load_google_api_key() {

			$api_key = get_theme_mod( 'google_api_key' );
			if ( ! empty( $api_key ) ) {
				wp_add_inline_script( 'lsvr-townpress-main-scripts', 'var lsvr_townpress_google_api_key = "' . esc_js( trim( $api_key ) ) . '";' );
			}

		}
	}

	// Load Mapbox API key
	add_action( 'lsvr_townpress_load_assets', 'lsvr_townpress_load_mapbox_api_key' );
	if ( ! function_exists( 'lsvr_townpress_load_mapbox_api_key' ) ) {
		function lsvr_townpress_load_mapbox_api_key() {

			if ( 'mapbox' === lsvr_townpress_get_maps_provider() && ! empty( get_theme_mod( 'mapbox_api_key' ) ) ) {
				wp_add_inline_script( 'lsvr-townpress-main-scripts', 'var lsvr_townpress_mapbox_api_key = "' . esc_js( trim( get_theme_mod( 'mapbox_api_key' ) ) ) . '";' );
			}

		}
	}

	// Load Leaflet for header map
	add_action( 'lsvr_townpress_load_assets', 'lsvr_townpress_load_leaflet_js' );
	if ( ! function_exists( 'lsvr_townpress_load_leaflet_js' ) ) {
		function lsvr_townpress_load_leaflet_js() {

			$version = wp_get_theme( 'townpress' );
			$version = $version->Version;

			// Leaflet
			if ( lsvr_townpress_has_maps_leaflet_platform() && true === apply_filters( 'lsvr_townpress_header_map_enable', false ) ) {
				wp_enqueue_script( 'leaflet', get_template_directory_uri() . '/assets/js/leaflet.min.js', false, $version, true );
			}

		}
	}

	// Load Google Maps style
	add_action( 'lsvr_townpress_load_assets', 'lsvr_townpress_load_google_maps_style', 10, 2 );
	if ( ! function_exists( 'lsvr_townpress_load_google_maps_style' ) ) {
		function lsvr_townpress_load_google_maps_style() {

			if ( is_singular( 'lsvr_listing' ) || is_post_type_archive( 'lsvr_listing' ) || is_tax( 'lsvr_listing_cat' ) || is_tax( 'lsvr_listing_tag' ) || is_singular( 'lsvr_event' ) || is_page() ) {

				$custom_map_style = get_theme_mod( 'google_maps_style_custom', '' );

				if ( 'custom' === get_theme_mod( 'google_maps_style', 'default' ) && ! empty( $custom_map_style ) ) {
					wp_add_inline_script( 'lsvr-townpress-main-scripts', 'var lsvr_townpress_google_maps_style_json = ' . json_encode( $custom_map_style ) . ';' );
				}

			}

		}
	}

	// Load JS labels
	add_action( 'lsvr_townpress_load_assets', 'lsvr_townpress_load_js_labels' );
	if ( ! function_exists( 'lsvr_townpress_load_js_labels' ) ) {
		function lsvr_townpress_load_js_labels() {

			$js_labels = array();

			// Magnific popup JS labels
			if ( true === apply_filters( 'lsvr_townpress_default_lightbox_enable', true ) ) {
				$js_labels[ 'magnific_popup' ] = array(
					'mp_tClose' => esc_html__( 'Close (Esc)', 'townpress' ),
					'mp_tLoading' => esc_html__( 'Loading...', 'townpress' ),
					'mp_tPrev' => esc_html__( 'Previous (Left arrow key)', 'townpress' ),
					'mp_tNext' => esc_html__( 'Next (Right arrow key)', 'townpress' ),
					'mp_image_tError' => esc_html__( 'The image could not be loaded.', 'townpress' ),
					'mp_ajax_tError' => esc_html__( 'The content could not be loaded.', 'townpress' ),
				);
			}

			// Apply filters
			$js_labels = array_merge( $js_labels, apply_filters( 'lsvr_townpress_add_js_labels', array() ) );

			// Convert to JS
			if ( ! empty( $js_labels ) ) {
				wp_add_inline_script( 'lsvr-townpress-main-scripts', 'var lsvr_townpress_js_labels = ' . json_encode( $js_labels ) );
			}

		}
	}

	// Add icon field to widgets
	add_action( 'in_widget_form', 'lsvr_townpress_widget_custom_options', 5, 3 );
	if ( ! function_exists( 'lsvr_townpress_widget_custom_options' ) ) {
		function lsvr_townpress_widget_custom_options( $t, $return, $instance ) {

			$default_icons = array(
				'archives' => 'icon-archive',
				'calendar' => 'icon-calendar-full',
				'categories' => 'icon-list4',
				'nav_menu' => 'icon-menu',
				'recent-comments' => 'icon-bubble',
				'recent-posts' => 'icon-reading',
				'search' => 'icon-magnifier',
				'lsvr_post_list' => 'icon-reading',
				'lsvr_post_featured' => 'icon-reading',
				'lsvr_townpress_weather' => 'icon-cloud-sun',
				'lsvr_notices_notice_list' => 'icon-bullhorn',
				'lsvr_notices_notice_categories' => 'icon-list4',
				'lsvr_directory_listing_list' => 'icon-map-marker',
				'lsvr_directory_listing_featured' => 'icon-map-marker',
				'lsvr_directory_listing_categories' => 'icon-list4',
				'lsvr_events_event_calendar' => 'icon-calendar-full',
				'lsvr_events_event_list' => 'icon-calendar-full',
				'lsvr_events_event_featured' => 'icon-calendar-full',
				'lsvr_events_event_locations' => 'icon-map-marker',
				'lsvr_events_event_categories' => 'icon-list4',
				'lsvr_events_event_filter' => 'icon-calendar-full',
				'lsvr_galleries_gallery_featured' => 'icon-image',
				'lsvr_galleries_gallery_list' => 'icon-pictures',
				'lsvr_galleries_gallery_categories' => 'icon-list4',
				'lsvr_documents_document_list' => 'icon-file-text-o',
				'lsvr_documents_document_featured' => 'icon-file-text-o',
				'lsvr_documents_document_attachments' => 'icon-file-text-o',
				'lsvr_documents_document_categories' => 'icon-list4',
				'lsvr_people_person_featured' => 'icon-user',
				'lsvr_people_person_list' => 'icon-users',
				'lsvr_people_person_categories' => 'icon-list4',
			);
			$icon_class = ! empty( $default_icons[ $t->id_base ] ) ? $default_icons[ $t->id_base ] : '';

			$instance = wp_parse_args( (array) $instance, array(
				'lsvr_iconclass' => $icon_class,
				'lsvr_boxed' => 'true'
			));

			if ( ! isset( $instance['lsvr_iconclass'] ) ) {
				$instance['lsvr_iconclass'] = null;
			}
			if ( ! isset( $instance['lsvr_boxed'] ) ) {
				$instance['lsvr_boxed'] = null;
			} ?>

			<p>
				<label for="<?php echo esc_attr( $t->get_field_id( 'lsvr_iconclass' ) ); ?>"><?php esc_html_e( 'Icon:', 'townpress' ); ?></label>
				<input type="text" class="widefat" name="<?php echo esc_attr( $t->get_field_name( 'lsvr_iconclass' ) ); ?>"
					id="<?php echo esc_attr( $t->get_field_id( 'lsvr_iconclass' ) ); ?>"
					value="<?php echo esc_attr( $instance[ 'lsvr_iconclass' ] ); ?>">
				<br><small><?php esc_html_e( 'Insert icon class name. For example "icon-magnifier". Please refer to the documentation to learn more about icons.', 'townpress' ); ?></small>
			</p>

			<?php $return = null;
			return array( $t, $return, $instance );

		}
	}

	add_filter( 'widget_update_callback', 'lsvr_townpress_widget_custom_options_update', 5, 3 );
	if ( ! function_exists( 'lsvr_townpress_widget_custom_options_update' ) ) {
		function lsvr_townpress_widget_custom_options_update( $instance, $new_instance, $old_instance ) {

			$instance['lsvr_iconclass'] = esc_attr( $new_instance['lsvr_iconclass'] );
			return $instance;

		}
	}

	add_filter( 'dynamic_sidebar_params', 'lsvr_townpress_widget_custom_params' );
	if ( ! function_exists( 'lsvr_townpress_widget_custom_params' ) ) {
		function lsvr_townpress_widget_custom_params( $params ) {

			global $wp_registered_widgets;
			$widget_id = ! empty( $params[0]['widget_id'] ) ? $params[0]['widget_id'] : false;
			$widget_obj = ! empty( $wp_registered_widgets[ $widget_id ] ) ? $wp_registered_widgets[ $widget_id ] : false;

			if ( ! empty( $widget_obj['_wo_original_callback'][0]->option_name ) ) {
				$widget_opt = get_option( $widget_obj['_wo_original_callback'][0]->option_name );
			} else if ( ! empty( $widget_obj['callback'][0]->option_name ) ) {
				$widget_opt = get_option( $widget_obj['callback'][0]->option_name );
			}

			if ( ! empty( $widget_obj['params'][0]['number'] ) ) {
				$widget_num = $widget_obj['params'][0]['number'];

				// Add icon
				if ( ! empty( $widget_opt[ $widget_num ]['lsvr_iconclass'] ) ) {
					$params[0]['before_title'] = '<h3 class="widget__title widget__title--has-icon"><span class="widget__title-icon ' . esc_attr( $widget_opt[ $widget_num ]['lsvr_iconclass'] ) . '" aria-hidden="true"></span>';
				}

			}

			return $params;

		}
	}

	// Add icon att to widget shortcodes
	add_filter( 'lsvr_townpress_weather_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_definition_list_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_post_featured_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_post_list_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_listing_list_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_listing_featured_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_document_list_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_document_featured_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_document_attachments_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_event_list_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_event_featured_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_gallery_list_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_gallery_featured_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_notice_list_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_person_list_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	add_filter( 'lsvr_person_featured_widget_shortcode_atts', 'lsvr_townpress_add_icon_shortcode_att' );
	if ( ! function_exists( 'lsvr_townpress_add_icon_shortcode_att' ) ) {
		function lsvr_townpress_add_icon_shortcode_att() {

			return array(
				array(
		        	'name' => 'icon',
		            'type' => 'text',
		            'label' => esc_html__( 'Icon', 'townpress' ),
		            'description' => esc_html__( 'Insert icon class name. Please refer to the documentation to learn more about icons.', 'townpress' ),
		            'priority' => 15,
	            ),
			);

		}
	}

	// Set current post type
	add_filter( 'lsvr_townpress_current_post_type', 'lsvr_townpress_blog_set_current_post_type' );
	if ( ! function_exists( 'lsvr_townpress_blog_set_current_post_type' ) ) {
		function lsvr_townpress_blog_set_current_post_type( $post_type ) {

			if ( lsvr_townpress_is_blog() ) {
				return 'post';
			}
			return $post_type;

		}
	}


/**
 * HEADER
 */

	// Add navbar placeholder
	add_filter( 'lsvr_townpress_header_top', 'lsvr_townpress_header_add_navbar_placeholder' );
	if ( ! function_exists( 'lsvr_townpress_header_add_navbar_placeholder' ) ) {
		function lsvr_townpress_header_add_navbar_placeholder() {

			if ( true === apply_filters( 'lsvr_townpress_header_navbar_enable', false ) && lsvr_townpress_has_sticky_navbar() ) {

				echo '<div class="header-navbar__placeholder"></div>';

			}

		}
	}

	// Enable header toolbar
	add_filter( 'lsvr_townpress_header_toolbar_enable', 'lsvr_townpress_header_toolbar_enable' );
	if ( ! function_exists( 'lsvr_townpress_header_toolbar_enable' ) ) {
		function lsvr_townpress_header_toolbar_enable() {

			if ( true === apply_filters( 'lsvr_townpress_header_languages_enable', false )
				|| true === apply_filters( 'lsvr_townpress_header_map_enable', false )
				|| true === get_theme_mod( 'header_login_enable', false )
				|| true === (bool) get_theme_mod( 'header_search_enable', true )
				|| has_nav_menu( 'lsvr-townpress-header-mobile-menu' ) ) {

				return true;

			} else {

				return false;

			}

		}
	}

	// Enable header languages
	add_filter( 'lsvr_townpress_header_languages_enable', 'lsvr_townpress_header_languages_enable' );
	if ( ! function_exists( 'lsvr_townpress_header_languages_enable' ) ) {
		function lsvr_townpress_header_languages_enable() {

			return ! empty( lsvr_townpress_get_languages() ) ? true : false;

		}
	}

	// Enable header map
	add_filter( 'lsvr_townpress_header_map_enable', 'lsvr_townpress_header_map_enable' );
	if ( ! function_exists( 'lsvr_townpress_header_map_enable' ) ) {
		function lsvr_townpress_header_map_enable() {

			$latlong = lsvr_townpress_get_header_map_latlong();
			$address = get_theme_mod( 'header_map_address' );

			if ( lsvr_townpress_has_maps_provider() &&
				( 'enable' === get_theme_mod( 'header_map_enable', 'disable' ) || ( 'enable-front' === get_theme_mod( 'header_map_enable', 'disable' ) && is_front_page() ) ) &&
				! empty( $latlong ) ) {

				return true;

			}

			else {
				return false;
			}

		}
	}

	// Enable header navbar
	add_filter( 'lsvr_townpress_header_navbar_enable', 'lsvr_townpress_header_navbar_enable' );
	if ( ! function_exists( 'lsvr_townpress_header_navbar_enable' ) ) {
		function lsvr_townpress_header_navbar_enable() {

			return has_nav_menu( 'lsvr-townpress-header-menu' ) ? true : false;

		}
	}

	// Enable header background
	add_filter( 'lsvr_townpress_header_background_enable', 'lsvr_townpress_header_background_enable' );
	if ( ! function_exists( 'lsvr_townpress_header_background_enable' ) ) {
		function lsvr_townpress_header_background_enable() {

			return ! empty( lsvr_townpress_get_header_background_images() ) ? true : false;

		}
	}


/**
 * CORE
 */

	// Archive layout
	add_filter( 'lsvr_townpress_blog_archive_layout', 'lsvr_townpress_blog_archive_layout' );
	if ( ! function_exists( 'lsvr_townpress_blog_archive_layout' ) ) {
		function lsvr_townpress_blog_archive_layout() {

			return 'default';

		}
	}

	// Main header title
	add_filter( 'lsvr_townpress_main_header_title', 'lsvr_townpress_main_header_title' );
	if ( ! function_exists( 'lsvr_townpress_main_header_title' ) ) {
		function lsvr_townpress_main_header_title( $title ) {

			if ( is_category() || is_tax() ) {
				return single_term_title( '', false );
			}

			elseif ( lsvr_townpress_is_blog() && ! is_singular( 'post' ) ) {
				return lsvr_townpress_get_blog_archive_title();
			}

			elseif ( is_search() ) {
				return esc_html__( 'Search Results', 'townpress' );
			}

			elseif ( is_post_type_archive( 'forum' ) && function_exists( 'lsvr_townpress_get_bbpress_archive_title' ) ) {
				return lsvr_townpress_get_bbpress_archive_title();
			}

			else {
				return get_the_title();
			}

			return $title;

		}
	}

	// Breadcrumbs
	add_filter( 'lsvr_townpress_breadcrumbs', 'lsvr_townpress_breadcrumbs' );
	if ( ! function_exists( 'lsvr_townpress_breadcrumbs' ) ) {
		function lsvr_townpress_breadcrumbs() {

			global $wp_query, $post;
			$breadcrumbs = [];

			// Home link
			$breadcrumbs[] = array(
				'url' => esc_url( home_url( '/' ) ),
				'label' => esc_html__( 'Home', 'townpress' ),
			);

			// Blog root for blog pages
			if ( get_option( 'page_for_posts' ) ) {
				$blog_root = array(
					'url' => get_permalink( get_option( 'page_for_posts' ) ),
					'label' => get_the_title( get_option( 'page_for_posts' ) ),
				);
			}
			else {
				$blog_root = array(
					'url' => esc_url( home_url( '/' ) ),
					'label' => esc_html__( 'News', 'townpress' ),
				);
			}

			// Blog
			if ( is_tag() || is_day() || is_month() || is_year() || is_author() || is_singular( 'post' ) ) {
				array_push( $breadcrumbs, $blog_root );
			}

			// Blog category
			else if ( is_category() ) {
				$breadcrumbs[] = $blog_root;
				$current_term = $wp_query->queried_object;
				$current_term_id = $current_term->term_id;
				$parent_ids = lsvr_townpress_get_term_parents( $current_term_id, 'category' );
				if ( ! empty( $parent_ids ) ) {
					foreach( $parent_ids as $parent_id ){
						$parent = get_term( $parent_id, 'category' );
						$breadcrumbs[] = array(
							'url' => get_term_link( $parent, 'category' ),
							'label' => $parent->name,
						);
					}
				}
			}

			// Regular page
			else if ( is_page() ) {
				$parent_id = $post->post_parent;
				$parents_arr = [];
				while ( $parent_id ) {
					$page = get_page( $parent_id );
					$parents_arr[] = array(
						'url' => get_permalink( $page->ID ),
						'label' => get_the_title( $page->ID ),
					);
					$parent_id = $page->post_parent;
				}
				$parents_arr = array_reverse( $parents_arr );
				foreach ( $parents_arr as $parent ) {
					$breadcrumbs[] = $parent;
				}
			}

			// Apply filters
			if ( ! empty( apply_filters( 'lsvr_townpress_add_to_breadcrumbs', array() ) ) ) {
				$breadcrumbs = array_merge( $breadcrumbs, apply_filters( 'lsvr_townpress_add_to_breadcrumbs', array() ) );
			}

			// Taxonomy
			if ( is_tax() ) {

				$taxonomy = get_query_var( 'taxonomy' );
				$term_parents = lsvr_townpress_get_term_parents( get_queried_object_id(), $taxonomy );
				if ( ! empty( $term_parents ) ) {
					foreach( $term_parents as $term_id ) {

						$term = get_term_by( 'id', $term_id, $taxonomy );
						$breadcrumbs[] = array(
							'url' => get_term_link( $term_id, $taxonomy ),
							'label' => $term->name,
						);

					}
				}
			}

			// Return breadcrumbs
			return $breadcrumbs;

		}
	}

	// pre_get_posts actions
	add_action( 'pre_get_posts', 'lsvr_townpress_author_archive_cpt_support' );
	if ( ! function_exists( 'lsvr_townpress_author_archive_cpt_support' ) ) {
		function lsvr_townpress_author_archive_cpt_support( $query ) {

	    	// Author page
		    if ( ! is_admin() && $query->is_author() && $query->is_main_query() ) {
		        $query->set( 'post_type', array( 'post', 'lsvr_notice', 'lsvr_document', 'lsvr_gallery' ) );
		    }

			// Search results
			if ( ! is_admin() && $query->is_search() && $query->is_main_query() ) {

				// Posts per page
				if ( 0 === (int) get_theme_mod( 'search_results_posts_per_page', 10 ) ) {
					$query->set( 'posts_per_page', 1000 );
				} else {
					$query->set( 'posts_per_page', esc_attr( get_theme_mod( 'search_results_posts_per_page', 10 ) ) );
				}

			}


		}
	}

	// Enable archive categories
	add_filter( 'lsvr_townpress_post_archive_categories_enable', 'lsvr_townpress_blog_archive_categories_enable' );
	if ( ! function_exists( 'lsvr_townpress_blog_archive_categories_enable' ) ) {
		function lsvr_townpress_blog_archive_categories_enable( $enabled ) {

			if ( lsvr_townpress_is_blog() && true === get_theme_mod( 'blog_archive_categories_enable', false ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Enable archive thumbnail cropping
	add_filter( 'lsvr_townpress_post_archive_cropped_thumbnail_enable', 'lsvr_townpress_blog_archive_cropped_thumbnail_enable' );
	if ( ! function_exists( 'lsvr_townpress_blog_archive_cropped_thumbnail_enable' ) ) {
		function lsvr_townpress_blog_archive_cropped_thumbnail_enable( $enabled ) {

			if ( lsvr_townpress_is_blog() && true === get_theme_mod( 'blog_archive_thumb_crop_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Enable post date on archive
	add_filter( 'lsvr_townpress_post_archive_post_footer_date_enable', 'lsvr_townpress_blog_archive_post_footer_date_enable' );
	if ( ! function_exists( 'lsvr_townpress_blog_archive_post_footer_date_enable' ) ) {
		function lsvr_townpress_blog_archive_post_footer_date_enable( $enabled ) {

			if ( lsvr_townpress_is_blog() ) {
				return true;
			}

			return $enabled;

		}
	}

	// Enable post author on archive
	add_filter( 'lsvr_townpress_post_archive_post_footer_author_enable', 'lsvr_townpress_blog_archive_post_footer_author_enable' );
	if ( ! function_exists( 'lsvr_townpress_blog_archive_post_footer_author_enable' ) ) {
		function lsvr_townpress_blog_archive_post_footer_author_enable( $enabled ) {

			if ( lsvr_townpress_is_blog() && true === get_theme_mod( 'blog_archive_author_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Enable post date on detail
	add_filter( 'lsvr_townpress_post_single_post_footer_date_enable', 'lsvr_townpress_blog_single_post_footer_date_enable' );
	if ( ! function_exists( 'lsvr_townpress_blog_single_post_footer_date_enable' ) ) {
		function lsvr_townpress_blog_single_post_footer_date_enable( $enabled ) {

			if ( lsvr_townpress_is_blog() ) {
				return true;
			}

			return $enabled;

		}
	}

	// Enable post author on detail
	add_filter( 'lsvr_townpress_post_single_post_footer_author_enable', 'lsvr_townpress_blog_single_post_footer_author_enable' );
	if ( ! function_exists( 'lsvr_townpress_blog_single_post_footer_author_enable' ) ) {
		function lsvr_townpress_blog_single_post_footer_author_enable( $enabled ) {

			if ( lsvr_townpress_is_blog() && true === get_theme_mod( 'blog_single_author_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Enable post single navigation
	add_filter( 'lsvr_townpress_post_single_navigation_enable', 'lsvr_townpress_blog_single_post_navigation_enable' );
	if ( ! function_exists( 'lsvr_townpress_blog_single_post_navigation_enable' ) ) {
		function lsvr_townpress_blog_single_post_navigation_enable( $enabled ) {

			if ( lsvr_townpress_is_blog() && true === get_theme_mod( 'blog_single_post_navigation_enable', true ) ) {
				$enabled = true;
			}

			return $enabled;

		}
	}

	// Set page left sidebar ID
	add_filter( 'lsvr_townpress_sidebar_left_id', 'lsvr_townpress_sidebar_left_id' );
	if ( ! function_exists( 'lsvr_townpress_sidebar_left_id' ) ) {
		function lsvr_townpress_sidebar_left_id( $sidebar_id ) {

			// Page
			if ( is_page() ) {

				$page_id = ! empty( $page_id ) ? $page_id : get_the_ID();
				$sidebar_id = ! empty( $page_id ) ? get_post_meta( $page_id, 'lsvr_townpress_page_sidebar_left', true ) : false;

				if ( ! empty( $sidebar_id ) ) {
					$sidebar_id = $sidebar_id;
				} else {
					$sidebar_id = 'lsvr-townpress-default-sidebar-left';
				}

			}

			// Is blog single
			elseif ( is_singular( 'post' ) ) {
				$sidebar_id = get_theme_mod( 'blog_single_sidebar_left_id', 'lsvr-townpress-default-sidebar-left' );
			}

			// Is blog archive
			elseif ( lsvr_townpress_is_blog() ) {
				$sidebar_id = get_theme_mod( 'blog_archive_sidebar_left_id', 'lsvr-townpress-default-sidebar-left' );
			}

			return ! empty( $sidebar_id ) ? $sidebar_id : 'lsvr-townpress-default-sidebar-left';

		}
	}

	// Set page right sidebar ID
	add_filter( 'lsvr_townpress_sidebar_right_id', 'lsvr_townpress_sidebar_right_id' );
	if ( ! function_exists( 'lsvr_townpress_sidebar_right_id' ) ) {
		function lsvr_townpress_sidebar_right_id( $sidebar_id ) {

			// Page
			if ( is_page() ) {

				$page_id = ! empty( $page_id ) ? $page_id : get_the_ID();
				$sidebar_id = ! empty( $page_id ) ? get_post_meta( $page_id, 'lsvr_townpress_page_sidebar_right', true ) : false;

				if ( ! empty( $sidebar_id ) ) {
					$sidebar_id = $sidebar_id;
				} else {
					$sidebar_id = '';
				}

			}

			// Is blog single
			elseif ( is_singular( 'post' ) ) {
				$sidebar_id = get_theme_mod( 'blog_single_sidebar_right_id', '' );
			}

			// Is blog archive
			elseif ( lsvr_townpress_is_blog() ) {
				$sidebar_id = get_theme_mod( 'blog_archive_sidebar_right_id', '' );
			}

			// Default right sidebar
			elseif ( 'disable' !== get_theme_mod( 'default_sidebar_right_id', 'disable' ) ) {
				$sidebar_id = get_theme_mod( 'default_sidebar_right_id', 'disable' );
			}

			return ! empty( $sidebar_id ) ? $sidebar_id : '';

		}
	}



/**
 * META DATA
 */

	// Add breadcrumbs meta
	add_action( 'lsvr_townpress_breadcrumbs_bottom', 'lsvr_townpress_add_breadcrumbs_meta' );
	if ( ! function_exists( 'lsvr_townpress_add_breadcrumbs_meta' ) ) {
		function lsvr_townpress_add_breadcrumbs_meta() { ?>

			<!-- BREADCRUMBS META DATA : begin -->
			<script type="application/ld+json">
			{
				"@context": "http://schema.org",
				"@type": "BreadcrumbList",
				"itemListElement" : [
					<?php $i = 1;
					$breadcrumbs = apply_filters( 'lsvr_townpress_breadcrumbs', '' );
					foreach ( $breadcrumbs as $breadcrumb ) : ?>
					{
						"@type": "ListItem",
						"position": <?php echo esc_attr( $i ); ?>,
						"item": {
							"@id": "<?php echo esc_url( $breadcrumb['url'] ); ?>",
							"name": "<?php echo esc_attr( $breadcrumb['label'] ); ?>"
						}
					}<?php if ( $breadcrumb !== end( $breadcrumbs ) ) { echo ','; } ?>
					<?php $i++; endforeach; ?>
				]
			}
			</script>
			<!-- BREADCRUMBS META DATA : end -->

		<?php }
	}

	// Add blog post meta data
	add_action( 'lsvr_townpress_blog_single_bottom', 'lsvr_townpress_add_blog_single_meta' );
	if ( ! function_exists( 'lsvr_townpress_add_blog_single_meta' ) ) {
		function lsvr_townpress_add_blog_single_meta() { ?>

			<script type="application/ld+json">
			{
				"@context" : "http://schema.org",
				"@type" : "NewsArticle",
				"headline": "<?php echo esc_attr( get_the_title() ); ?>",
				"url" : "<?php echo esc_url( get_permalink() ); ?>",
				"mainEntityOfPage" : "<?php echo esc_url( get_permalink() ); ?>",
			 	"datePublished": "<?php echo esc_attr( get_the_time( 'c' ) ); ?>",
			 	"dateModified": "<?php echo esc_attr( get_the_modified_date( 'c' ) ); ?>",
			 	"description": "<?php echo esc_attr( get_the_excerpt() ); ?>",
			 	"author": {
			 		"@type" : "person",
			 		"name" : "<?php echo esc_attr( get_the_author() ); ?>",
			 		"url" : "<?php esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"
			 	},
			 	"publisher" : {
			 		"@id" : "<?php echo esc_url( home_url() ); ?>#WebSitePublisher"
			 	}

			 	<?php if ( lsvr_townpress_has_post_terms( get_the_ID(), 'post_tag' ) ) : ?>
				,"keywords": "<?php echo esc_attr( implode( ',', lsvr_townpress_get_post_term_names( get_the_ID(), 'post_tag' ) ) ); ?>"
			 	<?php endif; ?>

				<?php if ( has_post_thumbnail() ) : ?>
			 	,"image": {
			 		"@type" : "ImageObject",
			 		"url" : "<?php the_post_thumbnail_url( 'full' ); ?>",
			 		"width" : "<?php echo esc_attr( lsvr_townpress_get_image_width( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
			 		"height" : "<?php echo esc_attr( lsvr_townpress_get_image_height( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
			 		"thumbnailUrl" : "<?php the_post_thumbnail_url( 'thumbnail' ); ?>"
			 	}
			 	<?php endif; ?>

			}
			</script>

		<?php }
	}

	// Add site meta data
	add_action( 'wp_footer', 'lsvr_townpress_add_site_meta', 10, 2 );
	if ( ! function_exists( 'lsvr_townpress_add_site_meta' ) ) {
		function lsvr_townpress_add_site_meta() { ?>

			<?php // Get URLs of social links and email address
			$social_links = lsvr_townpress_get_social_links();
			if ( ! empty( $social_links->email ) ) {
				$email = ! empty( $social_links->email->url ) ? $social_links->email->url : '';
				unset( $social_links->email );
			} ?>

			<script type="application/ld+json">
			{
				"@context" : "http://schema.org",
				"@type" : "WebSite",
				"name" : "<?php bloginfo( 'name' ); ?>",
				"url" : "<?php echo esc_url( home_url() ); ?>",
				"description" : "<?php bloginfo( 'description' ); ?>",
			 	"publisher" : {

			 		"@id" : "<?php echo esc_url( home_url() ); ?>#WebSitePublisher",
			 		"@type" : "Organization",
			 		"name" : "<?php echo esc_attr( get_bloginfo('name') ); ?>",
			 		"url" : "<?php echo esc_url( home_url() ); ?>"

					<?php if ( ! empty( $email ) ) : ?>
					,"contactPoint": {
				 		"@type": "ContactPoint",
				 		"contactType": "customer service",
				 		"url": "<?php echo esc_url( home_url() ); ?>",
				 		"email": "<?php echo esc_attr( $email ); ?>"
				 	}
					<?php endif; ?>

			 		<?php if ( has_custom_logo() ) : ?>
			 		,"logo" : {
			 			"@type" : "ImageObject",
			 			"url" : "<?php echo esc_url( lsvr_townpress_get_image_url( get_theme_mod( 'custom_logo' ) ) ); ?>",
						"width" : "<?php echo esc_attr( lsvr_townpress_get_image_width( get_theme_mod( 'custom_logo' ) ) ); ?>",
						"height" : "<?php echo esc_attr( lsvr_townpress_get_image_height( get_theme_mod( 'custom_logo' ) ) ); ?>"
			 		}
			 		<?php endif; ?>

					<?php if ( ! empty( $social_links ) ) : ?>
					,"sameAs" : [
						<?php foreach( $social_links as $social ) : if ( ! empty( $social->url ) ) : ?>
				    		"<?php echo esc_url( $social->url ); ?>"<?php if ( $social !== end( $social_links ) ) { echo ','; } ?>
						<?php endif; endforeach; ?>
				  	]
				  	<?php endif; ?>

			 	},
			 	"potentialAction": {
			    	"@type" : "SearchAction",
			    	"target" : "<?php echo esc_url( home_url() ); ?>/?s={search_term}",
			    	"query-input": "required name=search_term"
			    }
			}
			</script>

		<?php }
	}

?>