<?php

/**
 * GENERAL
 */

	// Document title
	add_filter( 'document_title_parts', 'lsvr_townpress_bbpress_title' );
	if ( ! function_exists( 'lsvr_townpress_bbpress_title' ) ) {
		function lsvr_townpress_bbpress_title( $title ) {

			if ( is_post_type_archive( 'forum' ) ) {
				$title['title'] = sanitize_text_field( lsvr_townpress_get_bbpress_archive_title() );
			}
			return $title;

		}
	}

	// Include bbPress topic CPT in search results
	add_filter( 'bbp_register_topic_post_type', 'lsvr_townpress_bbpress_topic_search_enable' );
	if ( ! function_exists( 'lsvr_townpress_bbpress_topic_search_enable' ) ) {
		function lsvr_townpress_bbpress_topic_search_enable( $topic_search ) {

			$topic_search['exclude_from_search'] = false;
			return $topic_search;

		}
	}

	// Include bbPress forum CPT in search results
	add_filter( 'bbp_register_forum_post_type', 'lsvr_townpress_bbpress_forum_search_enable' );
	if ( ! function_exists( 'lsvr_townpress_bbpress_forum_search_enable' ) ) {
		function lsvr_townpress_bbpress_forum_search_enable( $forum_search ) {

			$forum_search['exclude_from_search'] = false;
			return $forum_search;

		}
	}



/**
 * CORE
 */

	// Breadcrumbs
	add_filter( 'lsvr_townpress_add_to_breadcrumbs', 'lsvr_townpress_bbpress_breadcrumbs' );
	if ( ! function_exists( 'lsvr_townpress_bbpress_breadcrumbs' ) ) {
		function lsvr_townpress_bbpress_breadcrumbs( $breadcrumbs ) {

			if ( function_exists( 'is_bbpress' ) && is_bbpress() && ! is_post_type_archive( 'forum' ) ) {
				$breadcrumbs = array(
					array(
						'url' => get_post_type_archive_link( 'forum' ),
						'label' => lsvr_townpress_get_bbpress_archive_title(),
					),
				);
			}
			return $breadcrumbs;

		}
	}

	// Left sidebar ID
	add_filter( 'lsvr_townpress_sidebar_left_id', 'lsvr_townpress_bbpress_sidebar_left_id' );
	if ( ! function_exists( 'lsvr_townpress_bbpress_sidebar_left_id' ) ) {
		function lsvr_townpress_bbpress_sidebar_left_id( $sidebar_id ) {

			if ( function_exists( 'is_bbpress' ) && is_bbpress() ) {
				$sidebar_id = get_theme_mod( 'lsvr_bbpress_sidebar_left_id', 'lsvr-townpress-default-sidebar-left' );
			}

			return $sidebar_id;

		}
	}

	// Right sidebar ID
	add_filter( 'lsvr_townpress_sidebar_right_id', 'lsvr_townpress_bbpress_sidebar_right_id' );
	if ( ! function_exists( 'lsvr_townpress_bbpress_sidebar_right_id' ) ) {
		function lsvr_townpress_bbpress_sidebar_right_id( $sidebar_id ) {

			if ( function_exists( 'is_bbpress' ) && is_bbpress() ) {
				$sidebar_id = get_theme_mod( 'lsvr_bbpress_sidebar_right_id', 'disable' );
			}

			return $sidebar_id;

		}
	}

?>