<?php
// Header menu walker
if ( ! class_exists( 'Lsvr_Townpress_Header_Menu_Walker' ) ) {
    class Lsvr_Townpress_Header_Menu_Walker extends Walker_Nav_Menu {

        private $lsvr_current_item_id;

        function start_lvl( &$output, $depth = 0, $args = [] ) {
            ob_start(); ?>

        	<ul id="header-menu__submenu-<?php echo esc_attr( $this->lsvr_current_item_id ); ?>"
                class="header-menu__submenu sub-menu header-menu__submenu--level-<?php echo esc_attr( $depth ); ?>"
                aria-labelledby="header-menu__item-link-<?php echo esc_attr( $this->lsvr_current_item_id ); ?>"
                aria-expanded="false"
                role="menu">

            <?php $output .= ob_get_clean();

        }

        function end_lvl( &$output, $depth = 0, $args = [] ) {
            ob_start(); ?>

        	</ul>

            <?php $output .= ob_get_clean();
        }

        function start_el( &$output, $item, $depth = 0, $args = [], $id = 0 ) {
            $this->lsvr_current_item_id = $item->ID;
        	ob_start(); ?>

            <?php if ( 0 === $depth && ! empty( $item->description ) ) {
                $item->classes[] = 'header-mobile-menu__item--has-icon';
            } ?>

            <?php if ( 0 === $depth && ! empty( $item->classes ) && in_array( 'lsvr-megamenu', $item->classes ) ) {
                $item->classes[] = 'header-menu__item--megamenu';
            } elseif ( 0 === $depth ) {
                $item->classes[] = 'header-menu__item--dropdown';
            } ?>

        	<li id="header-menu__item-<?php echo esc_attr( $item->ID ); ?>"
                class="header-menu__item header-menu__item--level-<?php echo esc_attr( $depth ); ?> <?php echo ! empty( $item->classes ) ? esc_attr( trim( implode( ' ', $item->classes ) ) ) : ''; ?>"
                role="presentation">

                <a href="<?php echo esc_url( $item->url ); ?>"
                    id="header-menu__item-link-<?php echo esc_attr( $item->ID ); ?>"
                	class="header-menu__item-link header-menu__item-link--level-<?php echo esc_attr( $depth ); ?>"
                    role="menuitem"

                    <?php if ( in_array( 'menu-item-has-children', $item->classes ) ) : ?>

                        aria-owns="header-menu__submenu-<?php echo esc_attr( $item->ID ); ?>"
                        aria-controls="header-menu__submenu-<?php echo esc_attr( $item->ID ); ?>"
                        aria-haspopup="true"
                        aria-expanded="false"

                    <?php endif; ?>

                    <?php echo ! empty( $item->post_excerpt ) ? ' title="' . esc_attr( $item->post_excerpt ) . '"' : ''; ?>
                	<?php echo ! empty( $item->target ) ? ' target="' . esc_attr( $item->target ) . '"' : ''; ?>>

                    <?php if ( 0 === $depth && ! empty( $item->description ) ) : ?>

                        <span class="header-menu__item-link-icon header-menu__item-link-icon--level-<?php echo esc_attr( $depth ); ?> <?php echo esc_attr( $item->description ); ?>"
                            aria-hidden="true"></span>

                    <?php endif; ?>

                    <span class="header-menu__item-link-label">
                        <?php echo esc_html( apply_filters( 'the_title', $item->title, $item->ID ) ); ?>
                    </span>

                </a>

            <?php $output .= ob_get_clean();
        }

        function end_el( &$output, $item, $depth = 0, $args = [] ) {
            ob_start(); ?>

            </li>

            <?php $output .= ob_get_clean();

        }

    }
}