<?php
// Header menu walker
if ( ! class_exists( 'Lsvr_Townpress_Header_Mobile_Menu_Walker' ) ) {
    class Lsvr_Townpress_Header_Mobile_Menu_Walker extends Walker_Nav_Menu {

        private $lsvr_current_item_id;

        function start_lvl( &$output, $depth = 0, $args = [] ) {
            ob_start(); ?>

            <button id="header-mobile-menu__toggle-<?php echo esc_attr( $this->lsvr_current_item_id ); ?>"
                class="header-mobile-menu__toggle header-mobile-menu__toggle--level-<?php echo esc_attr( $depth ); ?>" type="button"
                aria-label="<?php echo esc_attr( esc_html__( 'Expand submenu', 'townpress' ) ); ?>"
                aria-controls="header-mobile-menu__submenu-<?php echo esc_attr( $this->lsvr_current_item_id ); ?>"
                aria-haspopup="true"
                aria-expanded="false">
                <span class="header-mobile-menu__toggle-icon" aria-hidden="true"></span>
            </button>

        	<ul id="header-mobile-menu__submenu-<?php echo esc_attr( $this->lsvr_current_item_id ); ?>"
                class="header-mobile-menu__submenu sub-menu header-mobile-menu__submenu--level-<?php echo esc_attr( $depth ); ?>"
                aria-labelledby="header-mobile-menu__item-link-<?php echo esc_attr( $this->lsvr_current_item_id ); ?>"
                aria-expanded="false"
                role="menu">

            <?php $output .= ob_get_clean();

        }

        function end_lvl( &$output, $depth = 0, $args = [] ) {
            ob_start(); ?>

        	</ul>

            <?php $output .= ob_get_clean();
        }

        function start_el( &$output, $item, $depth = 0, $args = [], $id = 0 ) {
            $this->lsvr_current_item_id = $item->ID;
        	ob_start(); ?>

            <?php if ( 0 === $depth && ! empty( $item->description ) ) {
                $item->classes[] = 'header-mobile-menu__item--has-icon';
            } ?>

        	<li id="header-mobile-menu__item-<?php echo esc_attr( $item->ID ); ?>"
                class="header-mobile-menu__item header-mobile-menu__item--level-<?php echo esc_attr( $depth ); ?> <?php echo ! empty( $item->classes ) ? esc_attr( trim( implode( ' ', $item->classes ) ) ) : ''; ?>"
                role="presentation">

                <a href="<?php echo esc_url( $item->url ); ?>"
                    id="header-mobile-menu__item-link-<?php echo esc_attr( $item->ID ); ?>"
                	class="header-mobile-menu__item-link header-mobile-menu__item-link--level-<?php echo esc_attr( $depth ); ?>"
                    role="menuitem"

                    <?php echo ! empty( $item->post_excerpt ) ? ' title="' . esc_attr( $item->post_excerpt ) . '"' : ''; ?>
                	<?php echo ! empty( $item->target ) ? ' target="' . esc_attr( $item->target ) . '"' : ''; ?>>

                    <?php if ( 0 === $depth && ! empty( $item->description ) ) : ?>

                        <span class="header-mobile-menu__item-link-icon header-mobile-menu__item-link-icon--level-<?php echo esc_attr( $depth ); ?> <?php echo esc_attr( $item->description ); ?>"
                            aria-hidden="true"></span>

                    <?php endif; ?>

                    <span class="header-mobile-menu__item-link-label">
                        <?php echo esc_html( apply_filters( 'the_title', $item->title, $item->ID ) ); ?>
                    </span>

                </a>

            <?php $output .= ob_get_clean();
        }

        function end_el( &$output, $item, $depth = 0, $args = [] ) {
            ob_start(); ?>

            </li>

            <?php $output .= ob_get_clean();

        }

    }
}