<?php

// Get page left sidebar ID
if ( ! function_exists( 'lsvr_townpress_get_page_sidebar_left_id' ) ) {
	function lsvr_townpress_get_page_sidebar_left_id( $page_id = false ) {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		// Page
		if ( is_page() ) {

			$page_id = ! empty( $page_id ) ? $page_id : get_the_ID();
			$sidebar_id = ! empty( $page_id ) ? get_post_meta( $page_id, 'lsvr_townpress_page_sidebar_left', true ) : false;

			if ( ! empty( $sidebar_id ) ) {
				$sidebar_id = $sidebar_id;
			} else {
				$sidebar_id = 'lsvr-townpress-default-sidebar-left';
			}

		}

		// Is blog single
		else if ( is_singular( 'post' ) ) {
			$sidebar_id = get_theme_mod( 'blog_single_sidebar_left_id', 'lsvr-townpress-default-sidebar-left' );
		}

		// Is blog archive
		else if ( lsvr_townpress_is_blog() ) {
			$sidebar_id = get_theme_mod( 'blog_archive_sidebar_left_id', 'lsvr-townpress-default-sidebar-left' );
		}

		// Filter
		else if ( ! empty( apply_filters( 'lsvr_townpress_sidebar_left_id', 'lsvr-townpress-default-sidebar-left' ) ) ) {
			$sidebar_id = apply_filters( 'lsvr_townpress_sidebar_left_id', 'lsvr-townpress-default-sidebar-left' );
		}

		// Default
		else {
			$sidebar_id = 'lsvr-townpress-default-sidebar-left';
		}

		$sidebar_id = ! empty( $sidebar_id ) ? $sidebar_id : 'lsvr-townpress-default-sidebar-left';

		return $sidebar_id;

	}
}

// Get page right sidebar ID
if ( ! function_exists( 'lsvr_townpress_get_page_sidebar_right_id' ) ) {
	function lsvr_townpress_get_page_sidebar_right_id( $page_id = false ) {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		// Page
		if ( is_page() ) {

			$page_id = ! empty( $page_id ) ? $page_id : get_the_ID();
			$sidebar_id = ! empty( $page_id ) ? get_post_meta( $page_id, 'lsvr_townpress_page_sidebar_right', true ) : false;

			if ( ! empty( $sidebar_id ) ) {
				$sidebar_id = $sidebar_id;
			} else {
				$sidebar_id = 'disable';
			}

		}

		// Is blog single
		else if ( is_singular( 'post' ) ) {
			$sidebar_id = get_theme_mod( 'blog_single_sidebar_right_id' );
		}

		// Is blog archive
		else if ( lsvr_townpress_is_blog() ) {
			$sidebar_id = get_theme_mod( 'blog_archive_sidebar_right_id', 'lsvr-townpress-default-sidebar-right' );
		}

		// Filter
		else if ( ! empty( apply_filters( 'lsvr_townpress_sidebar_right_id', 'lsvr-townpress-default-sidebar-right' ) ) ) {
			$sidebar_id = apply_filters( 'lsvr_townpress_sidebar_right_id', 'lsvr-townpress-default-sidebar-right' );
		}

		// Default
		else {
			$sidebar_id = 'lsvr-townpress-default-sidebar-right';
		}

		$sidebar_id = ! empty( $sidebar_id ) ? $sidebar_id : 'lsvr-townpress-default-sidebar-right';

		return $sidebar_id;

	}
}

// Has breadcrumbs
if ( ! function_exists( 'lsvr_townpress_has_breadcrumbs' ) ) {
	function lsvr_townpress_has_breadcrumbs( $page_id = false ) {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		return apply_filters( 'lsvr_townpress_enable_breadcrumbs', true );

	}
}

// Has header login
if ( ! function_exists( 'lsvr_townpress_has_header_login' ) ) {
	function lsvr_townpress_has_header_login() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		if ( true === (bool) get_theme_mod( 'header_login_enable', true ) && ! empty( get_theme_mod( 'header_login_page' ) ) ) {
			return true;
		} else {
			return false;
		}

	}
}

// Has header map
if ( ! function_exists( 'lsvr_townpress_has_header_map' ) ) {
	function lsvr_townpress_has_header_map() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		$latlong = lsvr_townpress_get_header_map_latlong();
		$address = get_theme_mod( 'header_map_address' );

		if ( ( 'enable' === get_theme_mod( 'header_map_enable', 'disable' )
			|| ( 'enable-front' === get_theme_mod( 'header_map_enable', 'disable' ) && is_front_page() ) )
			&& ( ! empty( $latlong ) || ! empty( $address ) ) ) {

			return true;

		}

		else {
			return false;
		}

	}
}

// Has header search
if ( ! function_exists( 'lsvr_townpress_has_header_search' ) ) {
	function lsvr_townpress_has_header_search() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		if ( true === (bool) get_theme_mod( 'header_search_enable', true ) ) {
			return true;
		} else {
			return false;
		}

	}
}

// Has languages
if ( ! function_exists( 'lsvr_townpress_has_languages' ) ) {
	function lsvr_townpress_has_languages() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		$languages = lsvr_townpress_get_languages();
		return ! empty( $languages ) ? true : false;

	}
}

// Has navbar
if ( ! function_exists( 'lsvr_townpress_has_navbar' ) ) {
	function lsvr_townpress_has_navbar() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		if ( has_nav_menu( 'lsvr-townpress-header-menu' ) ) {
			return true;
		} else {
			return false;
		}

	}
}

// Has page left sidebar
if ( ! function_exists( 'lsvr_townpress_has_page_sidebar_left' ) ) {
	function lsvr_townpress_has_page_sidebar_left( $page_id = false ) {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		$sidebar_id = lsvr_townpress_get_page_sidebar_left_id( $page_id );
		return $sidebar_id !== 'disable' ? true : false;

	}
}

// Has page right sidebar
if ( ! function_exists( 'lsvr_townpress_has_page_sidebar_right' ) ) {
	function lsvr_townpress_has_page_sidebar_right( $page_id = false ) {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		$sidebar_id = lsvr_townpress_get_page_sidebar_right_id( $page_id );
		return $sidebar_id !== 'disable' ? true : false;

	}
}


// Get breadcrumbs
if ( ! function_exists( 'lsvr_townpress_get_breadcrumbs' ) ) {
	function lsvr_townpress_get_breadcrumbs() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		global $wp_query, $post;
		$breadcrumbs = [];

		// Home link
		$breadcrumbs[] = array(
			'url' => esc_url( home_url( '/' ) ),
			'label' => esc_html__( 'Home', 'townpress' ),
		);

		// Blog root for blog pages
		if ( get_option( 'page_for_posts' ) ) {
			$blog_root = array(
				'url' => get_permalink( get_option( 'page_for_posts' ) ),
				'label' => get_the_title( get_option( 'page_for_posts' ) ),
			);
		}
		else {
			$blog_root = array(
				'url' => esc_url( home_url( '/' ) ),
				'label' => esc_html__( 'News', 'townpress' ),
			);
		}

		// Blog
		if ( is_tag() || is_day() || is_month() || is_year() || is_author() || is_singular( 'post' ) ) {
			array_push( $breadcrumbs, $blog_root );
		}

		// Blog category
		else if ( is_category() ) {
			$breadcrumbs[] = $blog_root;
			$current_term = $wp_query->queried_object;
			$current_term_id = $current_term->term_id;
			$parent_ids = lsvr_townpress_get_term_parents( $current_term_id, 'category' );
			if ( ! empty( $parent_ids ) ) {
				foreach( $parent_ids as $parent_id ){
					$parent = get_term( $parent_id, 'category' );
					$breadcrumbs[] = array(
						'url' => get_term_link( $parent, 'category' ),
						'label' => $parent->name,
					);
				}
			}
		}

		// Regular page
		else if ( is_page() ) {
			$parent_id = $post->post_parent;
			$parents_arr = [];
			while ( $parent_id ) {
				$page = get_page( $parent_id );
				$parents_arr[] = array(
					'url' => get_permalink( $page->ID ),
					'label' => get_the_title( $page->ID ),
				);
				$parent_id = $page->post_parent;
			}
			$parents_arr = array_reverse( $parents_arr );
			foreach ( $parents_arr as $parent ) {
				$breadcrumbs[] = $parent;
			}
		}

		// Apply filters
		if ( ! empty( apply_filters( 'lsvr_townpress_add_to_breadcrumbs', array() ) ) ) {
			$breadcrumbs = array_merge( $breadcrumbs, apply_filters( 'lsvr_townpress_add_to_breadcrumbs', array() ) );
		}

		// Taxonomy
		if ( is_tax() ) {

			$taxonomy = get_query_var( 'taxonomy' );
			$term_parents = lsvr_townpress_get_term_parents( get_queried_object_id(), $taxonomy );
			if ( ! empty( $term_parents ) ) {
				foreach( $term_parents as $term_id ) {

					$term = get_term_by( 'id', $term_id, $taxonomy );
					$breadcrumbs[] = array(
						'url' => get_term_link( $term_id, $taxonomy ),
						'label' => $term->name,
					);

				}
			}
		}

		// Return breadcrumbs
		return $breadcrumbs;

	}
}

// Blog post thumbnail
if ( ! function_exists( 'lsvr_townpress_the_blog_post_thumbnail' ) ) {
	function lsvr_townpress_the_blog_post_thumbnail( $post_id ) {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		if ( has_post_thumbnail( $post_id ) && true === get_theme_mod( 'blog_archive_thumb_crop_enable', true ) ) : ?>

			<!-- POST THUMBNAIL : begin -->
			<p class="post__thumbnail post__thumbnail--cropped">
				<a href="<?php the_permalink(); ?>" class="post__thumbnail-link post__thumbnail-link--cropped"
					<?php echo ' style="background-image: url( \'' . esc_url( get_the_post_thumbnail_url( $post_id, 'large' ) ) . '\' );"'; ?>></a>
			</p>
			<!-- POST THUMBNAIL : end -->

		<?php elseif ( has_post_thumbnail( $post_id ) ) : ?>

			<!-- POST THUMBNAIL : begin -->
			<p class="post__thumbnail">
				<a href="<?php the_permalink(); ?>" class="post__thumbnail-link"><?php the_post_thumbnail(); ?></a>
			</p>
			<!-- POST THUMBNAIL : end -->

		<?php endif;

	}
}

// Header background
if ( ! function_exists( 'lsvr_townpress_the_header_background' ) ) {
	function lsvr_townpress_the_header_background() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		$images = array();

		// Get background type
		$background_type = get_theme_mod( 'header_background_type', 'single' );

		// Set class
		$background_class_arr = array( 'header-background' );
		array_push( $background_class_arr, 'header-background--' . get_theme_mod( 'header_background_type', 'single' ) );

			// If is page and has featured image, use it instead of image defined via Customizer
			if ( is_page() && has_post_thumbnail( get_the_ID() ) ) {
			array_push( $images, get_the_post_thumbnail_url( get_the_ID() ) );
			}

			// Get image from Customizer
			else {

			// Get default image
			$default_image_url = get_theme_mod( 'header_background_image', '' );
			if ( ! empty( $default_image_url )  ) {
				array_push( $images, $default_image_url );
			}

			// Get additional images
			if ( 'slideshow' === $background_type || 'random' === $background_type ||
				( 'slideshow-home' === $background_type && is_front_page() ) ) {

				for ( $i = 2; $i <= 5; $i++ ) {

					$image_url = get_theme_mod( 'header_background_image_' . $i, '' );
					if ( ! empty( $image_url )  ) {
						array_push( $images, $image_url );
					}

				}

			}

		}

		// Create background element
		if ( ! empty( $images ) ) { ?>

			<div class="<?php echo implode( ' ', $background_class_arr ); ?>"
				data-slideshow-speed="<?php echo esc_attr( get_theme_mod( 'header_background_slideshow_speed', 10 ) ); ?>">

				<?php // Pick random image
				if ( 'random' === $background_type ) : $random_index = rand( 0, count( $images ) - 1 ); ?>

					<div class="header-background__image header-background__image--default"
						style="background-image: url( '<?php echo ! empty( $images[ $random_index ] ) ? esc_url( $images[ $random_index ] ) : esc_url( reset( $images ) ); ?>' );"></div>

				<?php // List all images
				else : ?>

					<?php foreach ( $images as $image_url ) : ?>

						<div class="header-background__image<?php if ( $image_url === reset( $images ) ) { echo ' header-background__image--default'; } ?>"
							style="background-image: url('<?php echo esc_url( $image_url ); ?>'); "></div>

					<?php endforeach; ?>

				<?php endif; ?>

			</div>

		<?php }

	}
}

// Header languages
if ( ! function_exists( 'lsvr_townpress_the_header_languages' ) ) {
	function lsvr_townpress_the_header_languages() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		$languages = lsvr_townpress_get_languages();
		$classes = array( 'header-toolbar__item header-languages' );

		if ( ! empty( $languages ) ) { ?>

			<!-- HEADER LANGUAGES : begin -->
			<div class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
				<span class="screen-reader-text"><?php esc_html_e( 'Choose language:', 'townpress' ); ?></span>
				<ul class="header-languages__list">

					<?php foreach ( $languages as $language ) : ?>
						<?php if ( ! empty( $language['label'] ) && ! empty( $language['url'] ) ) : ?>

							<li class="header-languages__item<?php if ( ! empty( $language['active'] ) ) { echo ' header-languages__item--active'; } ?>">
								<a href="<?php echo esc_url( $language['url'] ); ?>" class="header-languages__item-link"><?php echo esc_html( $language['label'] ); ?></a>
							</li>

						<?php endif; ?>
					<?php endforeach; ?>

				</ul>
			</div>
			<!-- HEADER LANGUAGES : end -->

		<?php }

	}
}

// Header login
if ( ! function_exists( 'lsvr_townpress_the_header_login' ) ) {
	function lsvr_townpress_the_header_login() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		if ( lsvr_townpress_has_header_login() ) : ?>

			<!-- HEADER LOGIN : begin -->
			<div class="header-login header-toolbar__item">

				<?php if ( is_user_logged_in() ) : ?>

					<?php $current_user = wp_get_current_user(); ?>

					<?php if ( function_exists( 'bbp_user_profile_edit_url' ) ) : ?>
						<a href="<?php bbp_user_profile_edit_url( bbp_get_current_user_id() ); ?>"
							class="header-login__profile-link"
							title="<?php echo esc_attr( $current_user->display_name ) . ' ' . esc_html__( '(edit profile)', 'townpress' ); ?>">
						<?php echo get_avatar( $current_user->ID, 40 ); ?></a>
					<?php endif; ?>

					<a href="<?php echo esc_url( wp_logout_url( get_home_url() ) ); ?>"
						class="header-login__link header-login__link--logout"
						title="<?php esc_html_e( 'Logout', 'townpress' ); ?>">
						<i class="header-login__ico icon-power-switch"></i>
					</a>

				<?php else : ?>

					<a href="<?php echo get_page_link( (int) get_theme_mod( 'header_login_page' ) ); ?>"
						class="header-login__link header-login__link--login"
						title="<?php echo get_theme_mod( 'header_login_label', esc_html__( 'Login', 'townpress' ) ); ?>">
						<i class="header-login__ico icon-key"></i>
					</a>

				<?php endif; ?>

			</div>
			<!-- HEADER LOGIN : end -->

		<?php endif;

	}
}

// Header map
if ( ! function_exists( 'lsvr_townpress_the_header_map' ) ) {
	function lsvr_townpress_the_header_map() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		$latlong = lsvr_townpress_get_header_map_latlong();
		$latlong = ! empty( $latlong ) ? implode( ',', $latlong ) : '';

		if ( lsvr_townpress_has_header_map() ) : ?>

			<div class="header-map header-map--loading">
				<div id="header-map-canvas" class="header-map__canvas"
					data-address="<?php echo esc_attr( get_theme_mod( 'header_map_address' ) ); ?>"
					data-latlong="<?php echo esc_attr( $latlong ); ?>"
					data-maptype="<?php echo esc_attr( get_theme_mod( 'header_map_type', 'roadmap' ) ); ?>"
					data-zoom="<?php echo esc_attr( get_theme_mod( 'header_map_zoom', 17 ) ); ?>"
					data-mousewheel="false">
				</div>
				<span class="c-spinner"></span>
				<button class="header-map__close" type="button"><i class="header-map__close-ico icon-cross"></i></button>
			</div>

		<?php endif;

	}
}

// Header map toggle
if ( ! function_exists( 'lsvr_townpress_the_header_map_toggle' ) ) {
	function lsvr_townpress_the_header_map_toggle( $mobile = false ) {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		$class = array( 'header-map-toggle' );
		if ( true === $mobile ) {
			array_push( $class, 'header-map-toggle--mobile' );
		} else {
			array_push( $class, 'header-map-toggle--desktop header-toolbar__item' );
		}

		if ( lsvr_townpress_has_header_map() ) : ?>

			<!-- HEADER MAP TOGGLE : begin -->
			<button class="<?php echo esc_attr( implode( ' ', $class ) ); ?>" type="button">
				<i class="header-map-toggle__ico header-map-toggle__ico--open icon-map2"></i>
				<i class="header-map-toggle__ico header-map-toggle__ico--close icon-cross"></i>
				<span class="header-map-toggle__label"><?php echo esc_html( get_theme_mod( 'header_map_toggle_label', esc_html__( 'Map', 'townpress' ) ) ); ?></span>
			</button>
			<!-- HEADER MAP TOGGLE : end -->

		<?php endif;

	}
}

// Header search
if ( ! function_exists( 'lsvr_townpress_the_header_search' ) ) {
	function lsvr_townpress_the_header_search() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		if ( lsvr_townpress_has_header_search() ) : ?>

			<!-- HEADER SEARCH : begin -->
			<div class="header-search header-toolbar__item">

				<?php get_search_form() ?>

			</div>
			<!-- HEADER SEARCH : end -->

		<?php endif;

	}
}

// Mobile toolbar toggle
if ( ! function_exists( 'lsvr_townpress_the_header_toolbar_toggle' ) ) {
	function lsvr_townpress_the_header_toolbar_toggle() {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		?>

		<!-- HEADER TOOLBAR TOGGLE : begin -->
		<div class="header-toolbar-toggle<?php if ( lsvr_townpress_has_header_map() ) { echo ' header-toolbar-toggle--has-map'; } ?>">

			<button class="header-toolbar-toggle__menu-button" type="button">
				<i class="header-toolbar-toggle__menu-button-ico header-toolbar-toggle__menu-button-ico--open icon-menu"></i>
				<i class="header-toolbar-toggle__menu-button-ico header-toolbar-toggle__menu-button-ico--close icon-cross"></i>
				<span class="header-toolbar-toggle__menu-button-label"><?php esc_html_e( 'Menu', 'townpress' ); ?></span>
			</button>

			<?php lsvr_townpress_the_header_map_toggle( true ); ?>

		</div>
		<!-- HEADER TOOLBAR TOGGLE : end -->

		<?php

	}
}

// Post archive categories
if ( ! function_exists( 'lsvr_townpress_the_post_archive_categories' ) ) {
	function lsvr_townpress_the_post_archive_categories( $post_type, $taxonomy ) {

		trigger_error( sprintf( LSVR_TOWNPRESS_DEPRECATED_ERROR_MSG, __METHOD__ ), E_USER_DEPRECATED );

		$terms = get_terms( $taxonomy );
		if ( ! empty( $terms ) ) { ?>

			<!-- POST ARCHIVE CATEGORIES : begin -->
			<div class="post-archive-categories">
				<div class="c-content-box">
					<h6 class="screen-reader-text"><?php esc_html_e( 'Categories:', 'townpress' ); ?></h6>
					<ul class="post-archive-categories__list">

						<li class="post-archive-categories__item">
							<?php if ( is_tax( $taxonomy ) ) : ?>
								<a href="<?php echo esc_url( get_post_type_archive_link( $post_type ) ); ?>" class="post-archive-categories__item-link"><?php esc_html_e( 'All', 'townpress' ); ?></a>
							<?php else : ?>
								<strong><?php esc_html_e( 'All', 'townpress' ); ?></strong>
							<?php endif; ?>
						</li>

						<?php foreach ( $terms as $term ) : ?>
							<li class="post-archive-categories__item">
								<?php if ( get_queried_object_id() === $term->term_id ) : ?>
									<?php echo esc_html( $term->name ); ?>
								<?php else : ?>
									<a href="<?php echo esc_url( get_term_link( $term->term_id, $taxonomy ) ); ?>" class="post-archive-categories__item-link"><?php echo esc_html( $term->name ); ?></a>
								<?php endif; ?>
							</li>
						<?php endforeach; ?>

					</ul>
				</div>
			</div>
			<!-- POST ARCHIVE CATEGORIES : end -->

		<?php }

	}
}

?>