<?php

/**
 * GENERAL
 */

	// Alert message
	if ( ! function_exists( 'lsvr_townpress_the_alert_message' ) ) {
		function lsvr_townpress_the_alert_message( $message ) {

			echo '<p class="c-alert-message">' . esc_html( $message ) . '</p>';

		}
	}

	// Post terms
	if ( ! function_exists( 'lsvr_townpress_the_post_terms' ) ) {
		function lsvr_townpress_the_post_terms( $post_id, $taxonomy, $template = '%s', $separator = ', ', $limit = 0 ) {

			if ( 'post_tag' === $taxonomy && true === apply_filters( 'lsvr_townpress_the_post_terms_the_tags_enable', false ) ) {
				the_tags();
			}

			else {

				$terms = wp_get_post_terms( $post_id, $taxonomy );
				$terms_parsed = array();
				if ( ! empty( $terms ) ) {
					foreach ( $terms as $term ) {
						array_push( $terms_parsed, '<a href="' . esc_url( get_term_link( $term->term_id, $taxonomy ) ) . '" class="post__term-link">' . esc_html( $term->name ) . '</a>' );
					}
					if ( $limit > 0 && count( $terms_parsed ) > $limit ) {
						$terms_parsed = array_slice( $terms_parsed, 0, $limit );
					}
				}

				$separator = ! empty( $separator ) ? '<span class="post__terms-separator" aria-hidden="true">' . $separator . '</span>' : '';

				if ( ! empty( $terms_parsed ) ) { ?>

					<span class="post__terms post__terms--<?php echo esc_attr( $taxonomy ); ?>">
						<?php echo sprintf( $template, implode( $separator, $terms_parsed ) ); ?>
					</span>

				<?php }

			}

		}
	}


/**
 * HEADER
 */

	// Header class
	if ( ! function_exists( 'lsvr_townpress_the_header_class' ) ) {
		function lsvr_townpress_the_header_class() {

			$class_arr = array();

			// Check if has navbar
			if ( true === apply_filters( 'lsvr_townpress_header_navbar_enable', false ) ) {
				array_push( $class_arr, 'header--has-navbar' );
			}

			// Check if has languages
			if ( true === apply_filters( 'lsvr_townpress_header_languages_enable', false ) ) {
				array_push( $class_arr, 'header--has-languages' );
			}

			// Check if has login
			if ( true === apply_filters( 'lsvr_townpress_header_login_enable', false ) ) {
				array_push( $class_arr, 'header--has-login' );
			}

			// Check if has map
			if ( true === apply_filters( 'lsvr_townpress_header_map_enable', false ) ) {
				array_push( $class_arr, 'header--has-map' );
			}

			// Echo
			echo ! empty( $class_arr ) ? ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"' : '';

		}
	}

	// Header navbar class
	if ( ! function_exists( 'lsvr_townpress_the_header_navbar_class' ) ) {
		function lsvr_townpress_the_header_navbar_class() {

			$class_arr = array( 'header-navbar' );

			// Check if sticky
			if ( lsvr_townpress_has_sticky_navbar() ) {
				array_push( $class_arr, 'header-navbar--sticky' );
			}

			// Echo
			if ( ! empty( $class_arr ) ) {
				echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
			}

		}
	}

	// Header logo class
	if ( ! function_exists( 'lsvr_townpress_the_header_logo_class' ) ) {
		function lsvr_townpress_the_header_logo_class( $custom_class = false ) {

			$class_arr = array( 'header-logo' );

			// Push custom class
			if ( ! empty( $custom_class ) ) {
				array_push( $class_arr, $custom_class );
			}

			// Check if front page
			if ( is_front_page() ) {
				array_push( $class_arr, 'header-logo--front' );
			}

			// Center logo
			if ( true === get_theme_mod( 'header_logo_centered_enable', false ) ) {
				array_push( $class_arr, 'header-logo--centered' );
			}

			// Echo
			if ( ! empty( $class_arr ) ) {
				echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
			}

		}
	}


/**
 * FOOTER
 */

	// Footer class
	if ( ! function_exists( 'lsvr_townpress_the_footer_class' ) ) {
		function lsvr_townpress_the_footer_class() {

			$class_arr = array();

			// Check if has background
			if ( lsvr_townpress_has_footer_background() ) {
				array_push( $class_arr, 'footer--has-background' );
			}

			// Echo
			if ( ! empty( $class_arr ) ) {
				echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
			}

		}
	}

	// Footer background
	if ( ! function_exists( 'lsvr_townpress_the_footer_background' ) ) {
		function lsvr_townpress_the_footer_background() {

			$image_url = get_theme_mod( 'footer_background_image' );
			if ( ! empty( $image_url ) ) {
				echo ' style="background-image: url( \'' . esc_url( $image_url ) . '\' );"';
			}

		}
	}

	// Footer widgets grid class
	if ( ! function_exists( 'lsvr_townpress_the_footer_widgets_grid_class' ) ) {
		function lsvr_townpress_the_footer_widgets_grid_class() {

			$classes = array( 'lsvr-grid' );
			$columns = get_theme_mod( 'footer_widgets_columns', 4 );

			// Cols
			array_push( $classes, 'lsvr-grid--' . $columns . '-cols' );

			// Cold md
			if ( $columns >= 2 ) {
				array_push( $classes, 'lsvr-grid--md-2-cols' );
			}

			if ( ! empty( $classes ) ) {
				echo ' class="' . esc_attr( implode( ' ', $classes ) ) . '"';
			}

		}
	}

?>