<?php
/**
 * Get header map latitude and longitude from address and save them into options table.
*/
add_action( 'customize_save_after', 'lsvr_townpress_geocode_header_map', 100 );
if ( ! function_exists( 'lsvr_townpress_geocode_header_map' ) ) {
	function lsvr_townpress_geocode_header_map() {

		if ( lsvr_townpress_has_maps_provider() ) {

			// Get map meta
			$map_meta = get_option( 'lsvr_townpress_header_map_meta' );

			// Get map address
			$address_saved = get_theme_mod( 'header_map_address', '' );

			// Get latitude and longitude
			$latitude = get_theme_mod( 'header_map_latitude', '' );
			$longitude = get_theme_mod( 'header_map_longitude', '' );

			// Proceed only if accurate address is not blank and latitude or longitude is blank
			if ( ! empty( $address_saved ) && ( empty( $latitude ) || empty( $longitude ) ) ) {

				// Get last geocoded accurate address from meta
				$address_geocoded = ! empty( $map_meta['address_geocoded'] ) ? $map_meta['address_geocoded'] : false;

				// Get geocoded latitude and longitude
				$latlong_geocoded = ! empty( $map_meta['latlong_geocoded'] ) ? $map_meta['latlong_geocoded'] : false;

				// Make sure the address changed from the last geocoding request to avoid unnecessary request
				// or if geocoded latitude and longitude are blank
				if ( ( $address_saved !== $address_geocoded ) || empty( $latlong_geocoded ) ) {

					// Prepare query URL for Google Maps
					if ( 'gmaps' === lsvr_townpress_get_maps_provider() ) {
						$query_url = 'https://maps.googleapis.com/maps/api/geocode/json?address=' . urlencode( esc_attr( $address_saved ) ) . '&key=' . esc_attr( get_theme_mod( 'google_api_key', '' ) );
					}

					// Prepare query URL for Mapbox
					elseif ( 'mapbox' === lsvr_townpress_get_maps_provider() ) {
						$query_url = 'https://api.mapbox.com/geocoding/v5/mapbox.places/' . urlencode( esc_attr( $address_saved ) ) . '.json?autocomplete=false&limit=1&access_token=' . esc_attr( get_theme_mod( 'mapbox_api_key', '' ) );
					}

					// Prepare query URL for Open Street Map
					else {
						$query_url = 'https://nominatim.openstreetmap.org/search/?q=' . urlencode( esc_attr( $address_saved ) ) . '&format=json&limit=1';
					}

					// Make request
					sleep(1);
					$response = wp_remote_get( esc_url_raw( $query_url ) );

					// Parse Google Maps response
					if ( 'gmaps' === lsvr_townpress_get_maps_provider() && is_array( $response ) && ! empty( $response['body'] ) ) {

						$response = json_decode( $response['body'] );

						// Check for data
						if ( is_object( $response ) && property_exists( $response, 'results' ) ) {

							$results = $response->results;
							$results = is_array( $results ) ? reset( $results ) : $results;

							// Check for data
							if ( ! empty( $results->geometry->location->lat ) && ! empty( $results->geometry->location->lng ) ) {
								$latitude_geocoded = $results->geometry->location->lat;
								$longitude_geocoded = $results->geometry->location->lng;
							}

						}

					}

					// Parse Mapbox response
					elseif ( 'mapbox' === lsvr_townpress_get_maps_provider() && is_array( $response ) && ! empty( $response['body'] ) ) {

						$response = json_decode( $response['body'] );

						if ( is_object( $response ) && property_exists( $response, 'features' ) ) {

							$results = $response->features;
							$results = is_array( $results ) ? reset( $results ) : $results;

							// Check for data
							if ( ! empty( $results->geometry->coordinates ) && is_array( $results->geometry->coordinates ) ) {

								$latitude_geocoded = $results->geometry->coordinates[1];
								$longitude_geocoded = $results->geometry->coordinates[0];

							}

						}

					}

					// Parse Open Street Map response
					elseif ( 'osm' === lsvr_townpress_get_maps_provider() && is_array( $response ) && ! empty( $response['body'] ) ) {

						$response = json_decode( $response['body'] );
						$results = is_array( $response ) ? reset( $response ) : $response;

						// Check for data
						if ( is_object( $results ) && ! empty( $results->lat ) && ! empty( $results->lon ) ) {

							$latitude_geocoded = $results->lat;
							$longitude_geocoded = $results->lon;

						}

					}

					// If geocoded latitude and longitude are retrieved, save them into meta
					if ( ! empty( $latitude_geocoded ) && ! empty( $longitude_geocoded ) ) {

						// Save geocoded latitude & longitude to term meta var
						$map_meta['latlong_geocoded'] = sanitize_text_field( $latitude_geocoded . ',' . $longitude_geocoded );

						// Copy the accurate_address into address_geocoded meta var to prevent unnecesarry requests
						// if the listing will be saved without address changing in the future
						$map_meta['address_geocoded'] = sanitize_text_field( $address_saved );

					}

				}

			}

			// If locating method is not set to 'address' or accurate address is blank, remove geocoded meta values from meta
			else {

				if ( is_array( $map_meta ) && array_key_exists( 'latlong_geocoded', $map_meta ) ) {
					unset( $map_meta['latlong_geocoded'] );
				}
				if ( is_array( $map_meta ) && array_key_exists( 'address_geocoded', $map_meta ) ) {
					unset( $map_meta['address_geocoded'] );
				}

			}

			// Save meta to options table
			if ( ! empty( $map_meta ) ) {
				update_option( 'lsvr_townpress_header_map_meta', $map_meta );
			}

		}

	}
}

?>