<?php

// Listing archive grid class
if ( ! function_exists( 'lsvr_townpress_the_listing_archive_grid_class' ) ) {
	function lsvr_townpress_the_listing_archive_grid_class() {

		$number_of_columns = ! empty( get_theme_mod( 'lsvr_listing_archive_grid_columns', 2 ) ) ? (int) get_theme_mod( 'lsvr_listing_archive_grid_columns', 2 ) : 2;
		$span = 12 / $number_of_columns;
		$md_cols = $span > 2 ? 2 : $span;
		$sm_cols = $span > 2 ? 2 : $span;
		$masonry = true === get_theme_mod( 'lsvr_listing_archive_masonry_enable', false ) ? ' lsvr-grid--masonry' : '';

		echo 'lsvr-grid lsvr-grid--' . esc_attr( $number_of_columns ) . '-cols lsvr-grid--md-' . esc_attr( $md_cols ) . '-cols lsvr-grid--sm-' . esc_attr( $sm_cols ) . '-cols' . esc_attr( $masonry );

	}
}

// Listing archive grid column class
if ( ! function_exists( 'lsvr_townpress_the_listing_archive_grid_column_class' ) ) {
	function lsvr_townpress_the_listing_archive_grid_column_class() {

		$number_of_columns = ! empty( get_theme_mod( 'lsvr_listing_archive_grid_columns', 2 ) ) ? (int) get_theme_mod( 'lsvr_listing_archive_grid_columns', 2 ) : 2;
		$span = 12 / $number_of_columns;

		// Get medium span class
		$span_md_class = 3 === $span || 4 === $span || 6 === $span ? ' lsvr-grid__col--md-span-6' : '';

		// Get small span class
		$span_sm_class = 3 === $span || 4 === $span || 6 === $span ? ' lsvr-grid__col--sm-span-6' : '';

		echo 'lsvr-grid__col lsvr-grid__col--span-' . esc_attr( $span . $span_md_class . $span_sm_class );

	}
}

// Listing address
if ( ! function_exists( 'lsvr_townpress_the_listing_address' ) ) {
	function lsvr_townpress_the_listing_address( $post_id, $nl2br = true ) {

		$location_address = lsvr_townpress_get_listing_address( $post_id );
		if ( ! empty( $location_address ) ) {
			echo true === $nl2br ? nl2br( esc_html( $location_address ) ) : esc_html( $location_address );
		}

	}
}

?>