<?php

/**
 * GENERAL
 */

	// Set current post type
	add_filter( 'lsvr_townpress_current_post_type', 'lsvr_townpress_notice_set_current_post_type' );
	if ( ! function_exists( 'lsvr_townpress_notice_set_current_post_type' ) ) {
		function lsvr_townpress_notice_set_current_post_type( $post_type ) {

			if ( lsvr_townpress_is_notice() ) {
				return 'lsvr_notice';
			}
			return $post_type;

		}
	}

	// Get archive taxonomy
	add_filter( 'lsvr_townpress_post_category_taxonomy', 'lsvr_townpress_notice_category_taxonomy' );
	if ( ! function_exists( 'lsvr_townpress_notice_category_taxonomy' ) ) {
		function lsvr_townpress_notice_category_taxonomy( $taxonomy ) {

			if ( lsvr_townpress_is_notice() ) {
				return 'lsvr_notice_cat';
			}

			return $taxonomy;

		}
	}

	// Get post tag taxonomy
	add_filter( 'lsvr_townpress_post_tag_taxonomy', 'lsvr_townpress_notice_tag_taxonomy' );
	if ( ! function_exists( 'lsvr_townpress_notice_tag_taxonomy' ) ) {
		function lsvr_townpress_notice_tag_taxonomy( $taxonomy ) {

			if ( lsvr_townpress_is_notice() ) {
				return 'lsvr_notice_tag';
			}

			return $taxonomy;

		}
	}

	// Document title
	add_filter( 'document_title_parts', 'lsvr_townpress_notice_title' );
	if ( ! function_exists( 'lsvr_townpress_notice_title' ) ) {
		function lsvr_townpress_notice_title( $title ) {

			if ( is_post_type_archive( 'lsvr_notice' ) ) {
				$title['title'] = sanitize_text_field( lsvr_townpress_get_notice_archive_title() );
			}
			return $title;

		}
	}


/**
 * CORE
 */

	// Archive layout
	add_filter( 'lsvr_townpress_notice_archive_layout', 'lsvr_townpress_notice_archive_layout' );
	if ( ! function_exists( 'lsvr_townpress_notice_archive_layout' ) ) {
		function lsvr_townpress_notice_archive_layout() {

			return 'default';

		}
	}

	// Page title
	add_filter( 'lsvr_townpress_main_header_title', 'lsvr_townpress_notice_main_header_title' );
	if ( ! function_exists( 'lsvr_townpress_notice_main_header_title' ) ) {
		function lsvr_townpress_notice_main_header_title( $title ) {

			if ( is_post_type_archive( 'lsvr_notice' ) ) {
				$title = lsvr_townpress_get_notice_archive_title();
			}

			return $title;

		}
	}

	// Breadcrumbs
	add_filter( 'lsvr_townpress_add_to_breadcrumbs', 'lsvr_townpress_notice_breadcrumbs' );
	if ( ! function_exists( 'lsvr_townpress_notice_breadcrumbs' ) ) {
		function lsvr_townpress_notice_breadcrumbs( $breadcrumbs ) {

			if ( lsvr_townpress_is_notice() && ! is_post_type_archive( 'lsvr_notice' ) ) {
				$breadcrumbs = array(
					array(
						'url' => get_post_type_archive_link( 'lsvr_notice' ),
						'label' => lsvr_townpress_get_notice_archive_title(),
					),
				);
			}
			return $breadcrumbs;

		}
	}

	// Archive pre_get_posts actions
	add_action( 'pre_get_posts', 'lsvr_townpress_notice_archive_pre_get_posts' );
	if ( ! function_exists( 'lsvr_townpress_notice_archive_pre_get_posts' ) ) {
		function lsvr_townpress_notice_archive_pre_get_posts( $query ) {
			if ( ! is_admin() && $query->is_main_query() && ( $query->is_post_type_archive( 'lsvr_notice' ) ||
				$query->is_tax( 'lsvr_notice_cat' ) || $query->is_tax( 'lsvr_notice_tag' ) ) ) {

				// Listing order
				$order = get_theme_mod( 'lsvr_notice_archive_order', 'default' );
				if ( 'date_asc' === $order ) {
					$query->set( 'orderby', 'date' );
					$query->set( 'order', 'ASC' );
				}
				else if ( 'date_desc' === $order ) {
					$query->set( 'orderby', 'date' );
					$query->set( 'order', 'DESC' );
				}
				else if ( 'title_asc' === $order ) {
					$query->set( 'orderby', 'title' );
					$query->set( 'order', 'ASC' );
				}
				else if ( 'title_desc' === $order ) {
					$query->set( 'orderby', 'title' );
					$query->set( 'order', 'DESC' );
				}
				else if ( 'random' === $order ) {
					$query->set( 'orderby', 'rand' );
				}

				// Posts per page
				if ( 0 === (int) get_theme_mod( 'lsvr_notice_archive_posts_per_page', 10 ) ) {
					$query->set( 'posts_per_page', 1000 );
				} else {
					$query->set( 'posts_per_page', esc_attr( get_theme_mod( 'lsvr_notice_archive_posts_per_page', 10 ) ) );
				}

			}
		}
	}

	// Enable archive categories
	add_filter( 'lsvr_townpress_post_archive_categories_enable', 'lsvr_townpress_notice_archive_categories_enable' );
	if ( ! function_exists( 'lsvr_townpress_notice_archive_categories_enable' ) ) {
		function lsvr_townpress_notice_archive_categories_enable( $enabled ) {

			if ( lsvr_townpress_is_notice() && true === get_theme_mod( 'lsvr_notice_archive_categories_enable', false ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Enable post date on archive
	add_filter( 'lsvr_townpress_post_archive_post_footer_date_enable', 'lsvr_townpress_notice_archive_post_footer_date_enable' );
	if ( ! function_exists( 'lsvr_townpress_notice_archive_post_footer_date_enable' ) ) {
		function lsvr_townpress_notice_archive_post_footer_date_enable( $enabled ) {

			if ( lsvr_townpress_is_notice() ) {
				return true;
			}

			return $enabled;

		}
	}

	// Enable post author on archive
	add_filter( 'lsvr_townpress_post_archive_post_footer_author_enable', 'lsvr_townpress_notice_archive_post_footer_author_enable' );
	if ( ! function_exists( 'lsvr_townpress_notice_archive_post_footer_author_enable' ) ) {
		function lsvr_townpress_notice_archive_post_footer_author_enable( $enabled ) {

			if ( lsvr_townpress_is_notice() && true === get_theme_mod( 'lsvr_notice_archive_author_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Enable post date on detail
	add_filter( 'lsvr_townpress_post_single_post_footer_date_enable', 'lsvr_townpress_notice_single_post_footer_date_enable' );
	if ( ! function_exists( 'lsvr_townpress_notice_single_post_footer_date_enable' ) ) {
		function lsvr_townpress_notice_single_post_footer_date_enable( $enabled ) {

			if ( lsvr_townpress_is_notice() ) {
				return true;
			}

			return $enabled;

		}
	}

	// Enable post author on detail
	add_filter( 'lsvr_townpress_post_single_post_footer_author_enable', 'lsvr_townpress_notice_single_post_footer_author_enable' );
	if ( ! function_exists( 'lsvr_townpress_notice_single_post_footer_author_enable' ) ) {
		function lsvr_townpress_notice_single_post_footer_author_enable( $enabled ) {

			if ( lsvr_townpress_is_notice() && true === get_theme_mod( 'lsvr_notice_single_author_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Left sidebar ID
	add_filter( 'lsvr_townpress_sidebar_left_id', 'lsvr_townpress_notice_sidebar_left_id' );
	if ( ! function_exists( 'lsvr_townpress_notice_sidebar_left_id' ) ) {
		function lsvr_townpress_notice_sidebar_left_id( $sidebar_id ) {

			// Single
			if ( is_singular( 'lsvr_notice' ) ) {
				$sidebar_id = get_theme_mod( 'lsvr_notice_single_sidebar_left_id', 'lsvr-townpress-default-sidebar-left' );
			}

			// Archive
			else if ( lsvr_townpress_is_notice() ) {
				$sidebar_id = get_theme_mod( 'lsvr_notice_archive_sidebar_left_id', 'lsvr-townpress-default-sidebar-left' );
			}

			return $sidebar_id;

		}
	}

	// Right sidebar ID
	add_filter( 'lsvr_townpress_sidebar_right_id', 'lsvr_townpress_notice_sidebar_right_id' );
	if ( ! function_exists( 'lsvr_townpress_notice_sidebar_right_id' ) ) {
		function lsvr_townpress_notice_sidebar_right_id( $sidebar_id ) {

			// Single
			if ( is_singular( 'lsvr_notice' ) ) {
				$sidebar_id = get_theme_mod( 'lsvr_notice_single_sidebar_right_id', 'disable' );
			}

			// Archive
			else if ( lsvr_townpress_is_notice() ) {
				$sidebar_id = get_theme_mod( 'lsvr_notice_archive_sidebar_right_id', 'disable' );
			}

			return $sidebar_id;

		}
	}


/**
 * META DATA
 */

	// Add post meta data
	add_action( 'lsvr_townpress_notice_single_bottom', 'lsvr_townpress_add_notice_single_meta' );
	if ( ! function_exists( 'lsvr_townpress_add_notice_single_meta' ) ) {
		function lsvr_townpress_add_notice_single_meta() { ?>

			<script type="application/ld+json">
			{
				"@context" : "http://schema.org",
				"@type" : "NewsArticle",
				"headline": "<?php echo esc_attr( get_the_title() ); ?>",
				"url" : "<?php echo esc_url( get_permalink() ); ?>",
				"mainEntityOfPage" : "<?php echo esc_url( get_permalink() ); ?>",
			 	"datePublished": "<?php echo esc_attr( get_the_time( 'c' ) ); ?>",
			 	"dateModified": "<?php echo esc_attr( get_the_modified_date( 'c' ) ); ?>",
			 	"description": "<?php echo esc_attr( get_the_excerpt() ); ?>",
			 	"author": {
			 		"@type" : "person",
			 		"name" : "<?php echo esc_attr( get_the_author() ); ?>",
			 		"url" : "<?php esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"
			 	},
			 	"publisher" : {
			 		"@id" : "<?php echo esc_url( home_url() ); ?>#WebSitePublisher"
			 	}

			 	<?php if ( lsvr_townpress_has_post_terms( get_the_ID(), 'lsvr_notice_tag' ) ) : ?>
				,"keywords": "<?php echo esc_attr( implode( ',', lsvr_townpress_get_post_term_names( get_the_ID(), 'lsvr_notice_tag' ) ) ); ?>"
			 	<?php endif; ?>

			}
			</script>

		<?php }
	}

?>