<?php

add_action( 'customize_register', 'lsvr_townpress_notices_customize_register' );
if ( ! function_exists( 'lsvr_townpress_notices_customize_register' ) ) {
    function lsvr_townpress_notices_customize_register( $wp_customize ) {
        if ( class_exists( 'Lsvr_Customizer' ) ) {

            $lsvr_customizer = new Lsvr_Customizer( $wp_customize, 'lsvr_townpress_' );

            $lsvr_customizer->add_section( 'lsvr_notice_settings', array(
                'title' => esc_html__( 'Notices', 'townpress' ),
                'priority' => 125,
            ));

                // Archive settings
                $lsvr_customizer->add_info( 'lsvr_notice_archive_info', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Archive Settings', 'townpress' ),
                    'description' => esc_html__( 'The following settings apply to post archive page. You can change your default post archive URL under Settings / Permalinks. Scroll down for post detail page settings.', 'townpress' ),
                    'priority' => 1010,
                ));

                // Title
                $lsvr_customizer->add_field( 'lsvr_notice_archive_title', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Notice Archive Title', 'townpress' ),
                    'description' => esc_html__( 'This title will be used as the archive page headline and in breadcrumbs.', 'townpress' ),
                    'type' => 'text',
                    'default' => esc_html__( 'Notices', 'townpress' ),
                    'priority' => 1020,
                ));

                // Archive posts per page
                $lsvr_customizer->add_field( 'lsvr_notice_archive_posts_per_page', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Posts Per Page', 'townpress' ),
                    'description' => esc_html__( 'How many gallery posts should be displayed per page. Set to 0 to display all.', 'townpress' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ),
                    'default' => 10,
                    'priority' => 1030,
                ));

                // Archive items order
                $lsvr_customizer->add_field( 'lsvr_notice_archive_order', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Archive Order', 'townpress' ),
                    'description' => esc_html__( 'Choose how galleries will be ordered on the archive page.', 'townpress' ),
                    'type' => 'select',
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'townpress' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'townpress' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'townpress' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'townpress' ),
                        'title_desc' => esc_html__( 'By title, descending', 'townpress' ),
                        'random' => esc_html__( 'Random', 'townpress' ),
                    ),
                    'default' => 'default',
                    'priority' => 1040,
                ));

                // Enable categories
                $lsvr_customizer->add_field( 'lsvr_notice_archive_categories_enable', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Display Archive Categories', 'townpress' ),
                    'description' => esc_html__( 'Display links to notice categories.', 'townpress' ),
                    'type' => 'checkbox',
                    'default' => false,
                    'priority' => 1050,
                ));

                // Enable author on archive
                $lsvr_customizer->add_field( 'lsvr_notice_archive_author_enable', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Display Author on Archive', 'townpress' ),
                    'description' => esc_html__( 'Display post author on archive page.', 'townpress' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1060,
                ));

                // Archive left sidebar ID
                $lsvr_customizer->add_field( 'lsvr_notice_archive_sidebar_left_id', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Archive Left Sidebar', 'townpress' ),
                    'description' => esc_html__( 'Choose left sidebar to display on notice post archive.', 'townpress' ),
                    'type' => 'select',
                    'choices' => array_merge(
                        array( 'disable' => esc_html__( 'Disable', 'townpress' ) ),
                        lsvr_townpress_get_sidebars()
                    ),
                    'priority' => 1110,
                    'default' => 'lsvr-townpress-default-sidebar-left',
                ));

                // Archive right sidebar ID
                $lsvr_customizer->add_field( 'lsvr_notice_archive_sidebar_right_id', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Archive Right Sidebar', 'townpress' ),
                    'description' => esc_html__( 'Choose right sidebar to display on notice post archive.', 'townpress' ),
                    'type' => 'select',
                    'choices' => array_merge(
                        array( 'disable' => esc_html__( 'Disable', 'townpress' ) ),
                        lsvr_townpress_get_sidebars()
                    ),
                    'priority' => 1120,
                    'default' => 'disable',
                ));

                // Separator
                $lsvr_customizer->add_separator( 'lsvr_notice_separator_2', array(
                    'section' => 'lsvr_notice_settings',
                    'priority' => 2000,
                ));

                // Detail settings
                $lsvr_customizer->add_info( 'lsvr_notice_single_info', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Detail Settings', 'townpress' ),
                    'description' => esc_html__( 'The following settings apply to post detail pages.', 'townpress' ),
                    'priority' => 2010,
                ));

                // Enable author on detail
                $lsvr_customizer->add_field( 'lsvr_notice_single_author_enable', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Display Author on Detail', 'townpress' ),
                    'description' => esc_html__( 'Display post author on detail page.', 'townpress' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 2020,
                ));

                // Single left sidebar ID
                $lsvr_customizer->add_field( 'lsvr_notice_single_sidebar_left_id', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Detail Left Sidebar', 'townpress' ),
                    'description' => esc_html__( 'Choose left sidebar to display on notice post detail.', 'townpress' ),
                    'type' => 'select',
                    'choices' => array_merge(
                        array( 'disable' => esc_html__( 'Disable', 'townpress' ) ),
                        lsvr_townpress_get_sidebars()
                    ),
                    'priority' => 2110,
                    'default' => 'lsvr-townpress-default-sidebar-left',
                ));

                // Single right sidebar ID
                $lsvr_customizer->add_field( 'lsvr_notice_single_sidebar_right_id', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Detail Right Sidebar', 'townpress' ),
                    'description' => esc_html__( 'Choose right sidebar to display on notice post detail.', 'townpress' ),
                    'type' => 'select',
                    'choices' => array_merge(
                        array( 'disable' => esc_html__( 'Disable', 'townpress' ) ),
                        lsvr_townpress_get_sidebars()
                    ),
                    'priority' => 2120,
                    'default' => 'disable',
                ));

        }
    }
}

?>