<?php

add_action( 'customize_register', 'lsvr_townpress_people_customize_register' );
if ( ! function_exists( 'lsvr_townpress_people_customize_register' ) ) {
    function lsvr_townpress_people_customize_register( $wp_customize ) {
        if ( class_exists( 'Lsvr_Customizer' ) ) {

            $lsvr_customizer = new Lsvr_Customizer( $wp_customize, 'lsvr_townpress_' );

            $lsvr_customizer->add_section( 'lsvr_person_settings', array(
                'title' => esc_html__( 'People', 'townpress' ),
                'priority' => 170,
            ));

                // Archive settings
                $lsvr_customizer->add_info( 'lsvr_person_archive_info', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Archive Settings', 'townpress' ),
                    'description' => esc_html__( 'The following settings apply to post archive page. You can change your default post archive URL under Settings / Permalinks. Scroll down for post detail page settings.', 'townpress' ),
                    'priority' => 1010,
                ));

                // Title
                $lsvr_customizer->add_field( 'lsvr_person_archive_title', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Person Archive Title', 'townpress' ),
                    'description' => esc_html__( 'This title will be used as the archive page headline and in breadcrumbs.', 'townpress' ),
                    'type' => 'text',
                    'default' => esc_html__( 'People', 'townpress' ),
                    'priority' => 1020,
                ));

                // Archive posts per page
                $lsvr_customizer->add_field( 'lsvr_person_archive_posts_per_page', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Posts Per Page', 'townpress' ),
                    'description' => esc_html__( 'How many person posts should be displayed per page. Set to 0 to display all.', 'townpress' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ),
                    'default' => 0,
                    'priority' => 1030,
                ));

                // Archive grid columns
                $lsvr_customizer->add_field( 'lsvr_person_archive_grid_columns', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Number of Columns', 'townpress' ),
                    'description' => esc_html__( 'Divide layout into several columns. It is not recommended to set this to more than two columns if you are using both sidebars on your archive page.', 'townpress' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'default' => 2,
                    'priority' => 1040,
                ));

                // Archive items order
                $lsvr_customizer->add_field( 'lsvr_person_archive_order', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Archive Order', 'townpress' ),
                    'description' => esc_html__( 'Choose how person posts will be ordered on the archive page.', 'townpress' ),
                    'type' => 'select',
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'townpress' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'townpress' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'townpress' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'townpress' ),
                        'title_desc' => esc_html__( 'By title, descending', 'townpress' ),
                        'random' => esc_html__( 'Random', 'townpress' ),
                    ),
                    'default' => 'default',
                    'priority' => 1050,
                ));

                // Enable categories
                $lsvr_customizer->add_field( 'lsvr_person_archive_categories_enable', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Display Archive Categories', 'townpress' ),
                    'description' => esc_html__( 'Display links to person categories.', 'townpress' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1060,
                ));

                // Archive left sidebar ID
                $lsvr_customizer->add_field( 'lsvr_person_archive_sidebar_left_id', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Archive Left Sidebar', 'townpress' ),
                    'description' => esc_html__( 'Choose left sidebar to display on person post archive.', 'townpress' ),
                    'type' => 'select',
                    'choices' => array_merge(
                        array( 'disable' => esc_html__( 'Disable', 'townpress' ) ),
                        lsvr_townpress_get_sidebars()
                    ),
                    'priority' => 1210,
                    'default' => 'lsvr-townpress-default-sidebar-left',
                ));

                // Archive right sidebar ID
                $lsvr_customizer->add_field( 'lsvr_person_archive_sidebar_right_id', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Archive Right Sidebar', 'townpress' ),
                    'description' => esc_html__( 'Choose right sidebar to display on person post archive.', 'townpress' ),
                    'type' => 'select',
                    'choices' => array_merge(
                        array( 'disable' => esc_html__( 'Disable', 'townpress' ) ),
                        lsvr_townpress_get_sidebars()
                    ),
                    'priority' => 1220,
                    'default' => 'disable',
                ));

                // Separator
                $lsvr_customizer->add_separator( 'lsvr_person_separator_2', array(
                    'section' => 'lsvr_person_settings',
                    'priority' => 2000,
                ));

                // Detail settings
                $lsvr_customizer->add_info( 'lsvr_person_single_info', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Detail Settings', 'townpress' ),
                    'description' => esc_html__( 'The following settings apply to post detail pages.', 'townpress' ),
                    'priority' => 2010,
                ));

                // Single left sidebar ID
                $lsvr_customizer->add_field( 'lsvr_person_single_sidebar_left_id', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Detail Left Sidebar', 'townpress' ),
                    'description' => esc_html__( 'Choose left sidebar to display on person post detail.', 'townpress' ),
                    'type' => 'select',
                    'choices' => array_merge(
                        array( 'disable' => esc_html__( 'Disable', 'townpress' ) ),
                        lsvr_townpress_get_sidebars()
                    ),
                    'priority' => 2210,
                    'default' => 'lsvr-townpress-default-sidebar-left',
                ));

                // Single right sidebar ID
                $lsvr_customizer->add_field( 'lsvr_person_single_sidebar_right_id', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Detail Right Sidebar', 'townpress' ),
                    'description' => esc_html__( 'Choose right sidebar to display on person post detail.', 'townpress' ),
                    'type' => 'select',
                    'choices' => array_merge(
                        array( 'disable' => esc_html__( 'Disable', 'townpress' ) ),
                        lsvr_townpress_get_sidebars()
                    ),
                    'priority' => 2220,
                    'default' => 'disable',
                ));

        }
    }
}

?>