<?php $form_id = rand( 0, 1000 ); ?>
<!-- SEARCH FORM : begin -->
<form class="c-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get" role="search">
	<div class="c-search-form__inner">
		<div class="c-search-form__input-holder">

			<label class="c-search-form__input-label screen-reader-text" for="c-search-form__input-<?php echo esc_attr( $form_id ); ?>"><?php esc_html_e( 'Search:', 'townpress' ); ?></label>
			<input id="c-search-form__input-<?php echo esc_attr( $form_id ); ?>" class="c-search-form__input" type="text" name="s"
				value="<?php echo esc_attr( get_search_query() ); ?>"
				placeholder="<?php echo esc_attr( get_theme_mod( 'search_input_placeholder', esc_html__( 'Search this site...', 'townpress' ) ) ); ?>"
				aria-label="<?php esc_html_e( 'Search field', 'townpress' ); ?>">

			<button class="c-search-form__button" type="submit" title="<?php esc_html_e( 'Submit search', 'townpress' ); ?>">
				<span class="c-search-form__button-ico icon-magnifier" aria-hidden="true"></span></button>

		</div>
	</div>
</form>
<!-- SEARCH FORM : end -->