<?php get_header(); ?>

<?php // Main begin
get_template_part( 'template-parts/main-begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_gallery-post-page post-single lsvr_gallery-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<?php // Main header
				get_template_part( 'template-parts/main-header' ); ?>

				<?php // Add custom code before gallery images
				do_action( 'lsvr_townpress_gallery_single_images_before' ); ?>

				<?php // Gallery images
				get_template_part( 'template-parts/lsvr_gallery/single-images' ); ?>

				<?php // Add custom code after gallery images
				do_action( 'lsvr_townpress_gallery_single_images_after' ); ?>

				<?php if ( ! empty( get_post()->post_content ) || true === get_theme_mod( 'lsvr_gallery_single_date_enable', true )
					|| lsvr_townpress_has_post_terms( get_the_ID(), 'lsvr_gallery_cat' )
					|| lsvr_townpress_has_post_terms( get_the_ID(), 'lsvr_gallery_tag' ) ) : ?>

					<!-- POST WRAPPER : begin -->
					<div class="post__wrapper">
						<div class="c-content-box">

							<?php // Add custom code before content
							do_action( 'lsvr_townpress_gallery_single_content_before' ); ?>

							<?php // Post content
							get_template_part( 'template-parts/single-post-content' ); ?>

							<?php // Add custom code before footer
							do_action( 'lsvr_townpress_gallery_single_footer_before' ); ?>

							<?php // Post footer
							get_template_part( 'template-parts/single-post-footer' ); ?>

							<?php // Add custom code after footer
							do_action( 'lsvr_townpress_gallery_single_footer_after' ); ?>

						</div>
					</div>
					<!-- POST WRAPPER : end -->

				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_townpress_gallery_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

		<?php // Post navigation
		get_template_part( 'template-parts/single-navigation' ); ?>

	    <?php // Post comments
	    comments_template(); ?>

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // Main end
get_template_part( 'template-parts/main-end' ); ?>

<?php get_footer(); ?>