<?php get_header(); ?>

<?php // Main begin
get_template_part( 'template-parts/main-begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_listing-post-page post-single lsvr_listing-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<?php // Main header
				get_template_part( 'template-parts/main-header' ); ?>

				<!-- POST WRAPPER : begin -->
				<div class="post__wrapper">
					<div class="c-content-box">

						<?php // Add custom code before thumbnail
						do_action( 'lsvr_townpress_listing_single_thumbnail_before' ); ?>

						<?php // Thumbnail
						get_template_part( 'template-parts/single-post-thumbnail' ); ?>

						<?php // Post content
						get_template_part( 'template-parts/single-post-content' ); ?>

						<?php // Contact
						if ( lsvr_townpress_has_listing_contact_info( get_the_ID() ) ||
							lsvr_townpress_has_listing_social_links( get_the_ID() ) ) : ?>

							<!-- POST CONTACT : begin -->
							<div class="post__contact">

								<h2 class="post__contact-title"><?php esc_html_e( 'Contact', 'townpress' ); ?></h2>

								<?php // Add custom code before contact info
								do_action( 'lsvr_townpress_listing_single_contact_info_before' ); ?>

								<?php // Contact info
								get_template_part( 'template-parts/lsvr_listing/single-contact-info' ); ?>

								<?php // Add custom code before social links
								do_action( 'lsvr_townpress_listing_single_social_before' ); ?>

								<?php // Social links
								get_template_part( 'template-parts/lsvr_listing/single-social-links' ); ?>

								<?php // Add custom code after social links
								do_action( 'lsvr_townpress_listing_single_social_after' ); ?>

							</div>
							<!-- POST CONTACT : end -->

						<?php endif; ?>

						<?php // Add custom code before map
						do_action( 'lsvr_townpress_listing_single_map_before' ); ?>

						<?php // Map
						get_template_part( 'template-parts/lsvr_listing/single-map' ); ?>

						<?php // Add custom code before opening hours
						do_action( 'lsvr_townpress_listing_single_opening_hours_before' ); ?>

						<?php // Opening hours
						get_template_part( 'template-parts/lsvr_listing/single-opening-hours' ); ?>

						<?php // Add custom code before gallery
						do_action( 'lsvr_townpress_listing_single_gallery_before' ); ?>

						<?php // Gallery
						get_template_part( 'template-parts/lsvr_listing/single-gallery' ); ?>

						<?php // Post footer
						get_template_part( 'template-parts/single-post-footer' ); ?>

					</div>
				</div>
				<!-- POST WRAPPER : end -->

				<?php // Add custom code at post bottom
				do_action( 'lsvr_townpress_listing_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // Main end
get_template_part( 'template-parts/main-end' ); ?>

<?php get_footer(); ?>