<?php get_header(); ?>

<?php // Main begin
get_template_part( 'template-parts/main-begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_person-post-page post-single lsvr_person-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<?php // Main header
				get_template_part( 'template-parts/main-header' ); ?>

				<?php if ( has_post_thumbnail()
					|| lsvr_townpress_has_person_contact_info( get_the_ID() ) || lsvr_townpress_has_person_social_links( get_the_ID() ) ) : ?>

					<!-- POST CARD : begin -->
					<div class="post__card">
						<div class="post__card-inner c-content-box">

							<?php // Add custom code before thumbnail
							do_action( 'lsvr_townpress_person_single_thumbnail_before' ); ?>

							<?php // Thumbnail
							get_template_part( 'template-parts/single-post-thumbnail' ); ?>

							<?php if ( lsvr_townpress_has_person_contact_info( get_the_ID() ) || lsvr_townpress_has_person_social_links( get_the_ID() ) ) : ?>

								<div class="post__contact">

									<?php // Add custom code before contact info
									do_action( 'lsvr_townpress_person_single_contact_info_before' ); ?>

									<?php // Contact info
									get_template_part( 'template-parts/lsvr_person/contact-info' ); ?>

									<?php // Add custom code before social links
									do_action( 'lsvr_townpress_person_single_social_before' ); ?>

									<?php // Social links
									get_template_part( 'template-parts/lsvr_person/social-links' ); ?>

									<?php // Add custom code after social links
									do_action( 'lsvr_townpress_person_single_social_after' ); ?>

								</div>

							<?php endif; ?>

						</div>
					</div>
					<!-- POST CARD : begin -->

				<?php endif; ?>

				<?php if ( ! empty( get_post()->post_content ) ) : ?>

					<div class="c-content-box">

						<?php // Post content
						get_template_part( 'template-parts/single-post-content' ); ?>

					</div>

				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_townpress_person_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // Main end
get_template_part( 'template-parts/main-end' ); ?>

<?php get_footer(); ?>