<!-- POST ARCHIVE : begin -->
<div class="post-archive blog-post-archive blog-post-archive--default">

	<?php // Main header
	get_template_part( 'template-parts/main-header' ); ?>

	<?php // Archive categories
	get_template_part( 'template-parts/archive-categories' ); ?>

	<?php // Archive category description
	get_template_part( 'template-parts/archive-category-description' ); ?>

	<?php if ( have_posts() ) : ?>

		<?php while ( have_posts() ) : the_post(); ?>

			<!-- POST : begin -->
			<article <?php post_class(); ?>>
				<div class="post__inner c-content-box">

					<!-- POST HEADER : begin -->
					<header class="post__header">

						<?php // Post thumbnail
						get_template_part( 'template-parts/archive-post-thumbnail' ); ?>

						<!-- POST TITLE : begin -->
						<h2 class="post__title">
							<a href="<?php the_permalink(); ?>" class="post__title-link" rel="bookmark"><?php the_title(); ?></a>
						</h2>
						<!-- POST TITLE : end -->

					</header>
					<!-- POST HEADER : end -->

					<!-- POST CONTENT : begin -->
					<div class="post__content">
						<?php if ( ! empty( $post->post_excerpt ) ) : ?>

							<?php the_excerpt(); ?>

							<!-- POST PERMALINK : begin -->
							<p class="post__permalink">
								<a href="<?php the_permalink(); ?>" class="post__permalink-link" rel="bookmark">
									<?php esc_html_e( 'Read More', 'townpress' ); ?>
								</a>
							</p>
							<!-- POST PERMALINK : end -->

						<?php elseif ( $post->post_content ) : ?>

							<?php the_content(); ?>

						<?php endif; ?>
					</div>
					<!-- POST CONTENT : end -->

					<?php // Post footer
					get_template_part( 'template-parts/archive-post-footer' ); ?>

				</div>
			</article>
			<!-- POST : end -->

		<?php endwhile; ?>

		<?php // Pagination
		the_posts_pagination(); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->