<?php if ( true === apply_filters( 'lsvr_townpress_breadcrumbs_enable', true ) &&
	! empty( apply_filters( 'lsvr_townpress_breadcrumbs', '' ) ) &&
	count( apply_filters( 'lsvr_townpress_breadcrumbs', '' ) ) >= apply_filters( 'lsvr_townpress_breadcrumbs_min_length', 2 ) ) : ?>

	<?php do_action( 'lsvr_townpress_breadcrumbs_before' ); ?>

	<!-- BREADCRUMBS : begin -->
	<div class="breadcrumbs">
		<div class="breadcrumbs__inner">

			<?php do_action( 'lsvr_townpress_breadcrumbs_top' ); ?>

			<nav class="breadcrumbs__nav" aria-label="<?php echo esc_attr( esc_html__( 'Breadcrumbs', 'townpress' ) ); ?>">
				<ul class="breadcrumbs__list">

					<?php foreach ( apply_filters( 'lsvr_townpress_breadcrumbs', '' ) as $breadcrumb ) : ?>

						<li class="breadcrumbs__item">
							<a href="<?php echo esc_url( $breadcrumb['url'] ); ?>" class="breadcrumbs__link"><?php echo esc_html( $breadcrumb['label'] ); ?></a>
							<span class="breadcrumbs__item-decor" aria-hidden="true"><?php esc_html_e( '/', 'townpress' ); ?></span>
						</li>

					<?php endforeach; ?>

				</ul>
			</nav>

			<?php do_action( 'lsvr_townpress_breadcrumbs_bottom' ); ?>

		</div>
	</div>
	<!-- BREADCRUMBS : end -->

	<?php do_action( 'lsvr_townpress_breadcrumbs_after' ); ?>

<?php endif; ?>
