<?php if ( lsvr_townpress_has_footer_social_links() || lsvr_townpress_has_footer_text() ||
	has_nav_menu( 'lsvr-townpress-footer-menu' ) ) : ?>

	<!-- FOOTER BOTTOM : begin -->
	<div class="footer-bottom">
		<div class="lsvr-container">
			<div class="footer-bottom__inner">

				<?php // Add custom code before footer social links
				do_action( 'lsvr_townpress_footer_social_links_before' ); ?>

				<?php // Social links
				get_template_part( 'template-parts/footer/social-links' ); ?>

				<?php // Add custom code before footer menu
				do_action( 'lsvr_townpress_footer_menu_before' ); ?>

				<?php // Footer menu
				get_template_part( 'template-parts/footer/menu' ); ?>

				<?php // Add custom code after footer menu
				do_action( 'lsvr_townpress_footer_menu_after' ); ?>

				<?php // Footer text
				get_template_part( 'template-parts/footer/text' ); ?>

				<?php // Add custom code after footer text
				do_action( 'lsvr_townpress_footer_text_after' ); ?>

				<?php // Back to top button
				if ( 'disable' !== get_theme_mod( 'back_to_top_button_enable', 'disable' ) ) : ?>

					<!-- BACK TO TOP : begin -->
					<div class="back-to-top back-to-top--type-<?php echo esc_attr( get_theme_mod( 'back_to_top_button_enable', 'disable' ) ); ?>">
						<a class="back-to-top__link" href="#header" title="<?php echo esc_attr( esc_html__( 'Back to top', 'townpress' ) ); ?>"></a>
					</div>
					<!-- BACK TO TOP : end -->

				<?php endif; ?>

			</div>
		</div>
	</div>
	<!-- FOOTER BOTTOM : end -->

<?php endif; ?>