<?php if ( true === apply_filters( 'lsvr_townpress_header_background_enable', false ) ) : $images = lsvr_townpress_get_header_background_images(); ?>

	<div class="header-background header-background--<?php echo esc_attr( get_theme_mod( 'header_background_type', 'single' ) ); ?>"
		data-slideshow-speed="<?php echo esc_attr( get_theme_mod( 'header_background_slideshow_speed', 10 ) ); ?>">

		<?php // Pick random image
		if ( 'random' === get_theme_mod( 'header_background_type', 'single' ) ) : $random_index = rand( 0, count( $images ) - 1 ); ?>

			<div class="header-background__image header-background__image--default"
				style="background-image: url( '<?php echo ! empty( $images[ $random_index ] ) ? esc_url( $images[ $random_index ] ) : esc_url( reset( $images ) ); ?>' );"></div>

		<?php // List all images
		else : ?>

			<?php foreach ( $images as $image_url ) : ?>

				<div class="header-background__image<?php if ( $image_url === reset( $images ) ) { echo ' header-background__image--default'; } ?>"
					style="background-image: url('<?php echo esc_url( $image_url ); ?>'); "></div>

			<?php endforeach; ?>

		<?php endif; ?>

	</div>

<?php endif; ?>