<?php if ( true === get_theme_mod( 'header_login_enable', false ) ) : ?>

	<!-- HEADER LOGIN : begin -->
	<div class="header-login header-toolbar__item">

		<?php if ( is_user_logged_in() ) : ?>

			<?php if ( function_exists( 'bbp_user_profile_edit_url' ) ) : $current_user = wp_get_current_user(); ?>
				<a href="<?php bbp_user_profile_edit_url( bbp_get_current_user_id() ); ?>"
					class="header-login__profile-link"
					title="<?php echo esc_attr( $current_user->display_name ) . ' ' . esc_html__( '(edit profile)', 'townpress' ); ?>">
				<?php echo get_avatar( $current_user->ID, 40 ); ?></a>
			<?php endif; ?>

			<a href="<?php echo esc_url( wp_logout_url( get_home_url() ) ); ?>"
				class="header-login__link header-login__link--logout"
				title="<?php esc_html_e( 'Logout', 'townpress' ); ?>">
				<span class="header-login__ico icon-power-switch" aria-hidden="true"></span>
			</a>

		<?php else : ?>

			<a class="header-login__link header-login__link--login"

				<?php if ( 'page' === get_theme_mod( 'header_login_type', 'page' ) && ! empty( get_theme_mod( 'header_login_page' ) ) ) : ?>
					href="<?php echo get_page_link( (int) get_theme_mod( 'header_login_page' ) ); ?>"
				<?php elseif ( 'url' === get_theme_mod( 'header_login_type', 'page' ) && ! empty( get_theme_mod( 'header_login_url' ) ) ) : ?>
					href="<?php echo esc_url( get_theme_mod( 'header_login_url' ) ); ?>"
				<?php endif; ?>

				title="<?php echo get_theme_mod( 'header_login_label', esc_html__( 'Login / Register', 'townpress' ) ); ?>">
				<span class="header-login__ico icon-key" aria-hidden="true"></span>
			</a>

		<?php endif; ?>

	</div>
	<!-- HEADER LOGIN : end -->

<?php endif; ?>