<?php if ( true === apply_filters( 'lsvr_townpress_header_map_enable', false ) ) : ?>

	<!-- HEADER MAP : begin -->
	<div class="header-map header-map--loading header-map--<?php echo esc_attr( lsvr_townpress_get_maps_platform() ); ?>">
		<div id="header-map-canvas"
			class="header-map__canvas header-map__canvas--loading"
			data-map-platform="<?php echo esc_attr( lsvr_townpress_get_maps_platform() ); ?>"
			data-map-provider="<?php echo esc_attr( lsvr_townpress_get_maps_provider() ); ?>"
			data-latlong="<?php echo esc_attr( implode( ',', lsvr_townpress_get_header_map_latlong() ) ); ?>"

			<?php if ( ! empty( get_theme_mod( 'header_map_address' ) ) ) : ?>
				data-address="<?php echo esc_attr( get_theme_mod( 'header_map_address' ) ); ?>"
			<?php endif; ?>

			<?php if ( 'gmaps' === lsvr_townpress_get_maps_provider() ) : ?>
				data-maptype="<?php echo esc_attr( get_theme_mod( 'header_map_type', 'roadmap' ) ); ?>"
			<?php endif; ?>

			data-zoom="<?php echo esc_attr( get_theme_mod( 'header_map_zoom', 17 ) ); ?>"
			data-mousewheel="false"></div>
		<span class="c-spinner"></span>
		<button class="header-map__close" type="button"
			aria-label="<?php esc_html_e( 'Close map', 'townpress' ); ?>">
			<span class="header-map__close-ico icon-cross" aria-hidden="true"></span>
		</button>
	</div>
	<!-- HEADER MAP : end -->

<?php endif; ?>