<?php // Mobile menu
if ( has_nav_menu( 'lsvr-townpress-header-mobile-menu' ) ) : ?>

	<!-- HEADER MOBILE MENU : begin -->
	<nav id="header-mobile-menu" class="header-mobile-menu"
        data-label-expand-submenu="<?php echo esc_attr( esc_html__( 'Expand submenu', 'townpress' ) ); ?>"
        data-label-collapse-submenu="<?php echo esc_attr( esc_html__( 'Collapse submenu', 'townpress' ) ); ?>"

		<?php if ( ! empty( lsvr_townpress_get_menu_name_by_location( 'lsvr-townpress-header-mobile-menu' ) ) ) : ?>
			aria-label="<?php echo lsvr_townpress_get_menu_name_by_location( 'lsvr-townpress-header-mobile-menu' ); ?>"
		<?php endif; ?>>

	    <?php wp_nav_menu(
	        array(
	            'theme_location' => 'lsvr-townpress-header-mobile-menu',
				'container' => '',
				'menu_class' => 'header-mobile-menu__list',
				'fallback_cb' => '',
				'items_wrap' => '<ul id="%1$s" class="%2$s" role="menu">%3$s</ul>',
				'walker' => new Lsvr_Townpress_Header_Mobile_Menu_Walker(),
			)
		); ?>

	</nav>
	<!-- HEADER MOBILE MENU : end -->

<?php endif; ?>