<?php
/*
 * Events functionality supports recurring events created via custom DB table,
 * that's why we can't use standard WP loop but will have to do it via custom function instead
 */
?>

<!-- POST ARCHIVE : begin -->
<div class="lsvr_event-post-page post-archive lsvr_event-post-archive lsvr_event-post-archive--default">

	<?php // Main header
	get_template_part( 'template-parts/main-header' ); ?>

	<?php // Events categories
	get_template_part( 'template-parts/archive-categories' ); ?>

	<?php // Archive category description
	get_template_part( 'template-parts/archive-category-description' ); ?>

	<?php if ( lsvr_townpress_has_events() ) : ?>

		<!-- POST ARCHIVE GRID : begin -->
		<div class="post-archive__grid">

			<?php $i = 1; $event_occurrences = lsvr_townpress_get_event_archive(); foreach ( lsvr_townpress_get_event_archive() as $event_occurrence ) : ?>

				<?php lsvr_townpress_the_event_post_archive_grid_begin( $event_occurrence, $i ); ?>

				<div class="<?php lsvr_townpress_the_event_post_archive_grid_column_class(); ?>">

					<!-- POST : begin -->
					<article <?php lsvr_townpress_the_event_post_class( $event_occurrence['postid'] ); ?>>
						<div class="c-content-box post__inner">

							<!-- POST HEADER : begin -->
							<header class="post__header">

								<?php // Post thumbnail
								include( locate_template( 'template-parts/lsvr_event/archive-post-thumbnail.php' ) ); ?>

								<!-- POST TITLE : begin -->
								<h3 class="post__title">
									<a href="<?php echo esc_url( get_permalink( $event_occurrence['postid'] ) ); ?>" class="post__title-link" rel="bookmark"><?php echo esc_html( get_the_title( $event_occurrence['postid'] ) ); ?></a>
								</h3>
								<!-- POST TITLE : end -->

							</header>
							<!-- POST HEADER : end -->

							<?php // Post info
							include( locate_template( 'template-parts/lsvr_event/archive-post-info.php' ) ); ?>

						</div>
					</article>
					<!-- POST : end -->

				</div>

				<?php lsvr_townpress_the_event_post_archive_grid_end( $i, count( $event_occurrences ) ); ?>

			<?php $i++; endforeach; ?>

		</div>
		<!-- POST ARCHIVE GRID : end -->

		<?php // Pagination
		get_template_part( 'template-parts/lsvr_event/archive-pagination' ); ?>

	<?php else : ?>

		<?php lsvr_townpress_the_alert_message( esc_html__( 'No events matched your criteria', 'townpress' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->