<!-- POST INFO : begin -->
<ul class="post__info" aria-label="<?php echo esc_attr( esc_html__( 'Event Information', 'townpress' ) ); ?>">

	<!-- POST DATE : begin -->
	<li class="post__info-item post__info-item--date" title="<?php echo esc_attr( esc_html__( 'Event Date', 'townpress' ) ); ?>">

		<span class="post__info-item-icon post__info-item-icon--date" aria-hidden="true"></span>

		<?php // Multi-day event
		if ( lsvr_townpress_is_multiday_event( $event_occurrence['postid'] ) ) : ?>

			<?php echo esc_html( sprintf( esc_html__( '%s - %s', 'townpress' ),
				date_i18n( get_option( 'date_format' ), strtotime( $event_occurrence['start'] ) ),
				date_i18n( get_option( 'date_format' ), strtotime( $event_occurrence['end'] ) ) ) ); ?>

		<?php // Single-day event
		else : ?>

			<?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $event_occurrence['start'] ) ) ); ?>

		<?php endif; ?>

	</li>
	<!-- POST DATE : end -->

	<!-- POST TIME : begin -->
	<li class="post__info-item post__info-item--time" title="<?php echo esc_attr( esc_html__( 'Event Time', 'townpress' ) ); ?>">

		<span class="post__info-item-icon post__info-item-icon--time" aria-hidden="true"></span>

		<?php lsvr_townpress_the_event_archive_time( $event_occurrence, esc_html__( '%s - %s', 'townpress' ) ); ?>

	</li>
	<!-- POST TIME : end -->

	<?php if ( lsvr_townpress_has_event_location( $event_occurrence['postid'] ) ) : ?>

		<!-- POST LOCATION : begin -->
		<li class="post__info-item post__info-item--location" title="<?php echo esc_attr( esc_html__( 'Event Location', 'townpress' ) ); ?>">

			<span class="post__info-item-icon post__info-item-icon--location" aria-hidden="true"></span>

			<?php lsvr_townpress_the_event_location_linked( $event_occurrence['postid'], esc_html__( '%s', 'townpress' ) ); ?>

		</li>
		<!-- POST LOCATION : end -->

	<?php endif; ?>

</ul>
<!-- POST INFO : end -->