<?php if ( true === get_theme_mod( 'lsvr_gallery_archive_date_enable', true ) ||
	lsvr_townpress_has_post_terms( get_the_ID(), 'lsvr_gallery_cat' ) ||
	true === get_theme_mod( 'lsvr_gallery_archive_image_count_enable', true ) ) : ?>

	<!-- POST INFO : begin -->
	<ul class="post__info">

		<?php if ( true === get_theme_mod( 'lsvr_gallery_archive_date_enable', true ) ) : ?>

			<!-- POST DATE : begin -->
			<li class="post__info-item post__info-item--date" title="<?php echo esc_attr( esc_html__( 'Published date', 'townpress' ) ); ?>">

				<span class="post__info-item-icon post__info-item-icon--date" aria-hidden="true"></span>

				<?php echo esc_html( get_the_date() ); ?>

			</li>
			<!-- POST DATE : end -->

		<?php endif; ?>

		<?php if ( lsvr_townpress_has_post_terms( get_the_ID(), 'lsvr_gallery_cat' ) ) : ?>

			<!-- POST CATEGORY : begin -->
			<li class="post__info-item post__info-item--category" title="<?php echo esc_attr( esc_html__( 'Category', 'townpress' ) ); ?>">

				<span class="post__info-item-icon post__info-item-icon--category" aria-hidden="true"></span>

				<?php lsvr_townpress_the_post_terms( get_the_ID(), 'lsvr_gallery_cat' ); ?>

			</li>
			<!-- POST CATEGORY : end -->

		<?php endif; ?>

		<?php if ( true === get_theme_mod( 'lsvr_gallery_archive_image_count_enable', true ) ) : ?>

			<!-- POST IMAGES COUNT : begin -->
			<li class="post__info-item post__info-item--images" title="<?php echo esc_attr( esc_html__( 'Number of images in gallery', 'townpress' ) ); ?>">

				<span class="post__info-item-icon post__info-item-icon--images" aria-hidden="true"></span>

				<?php echo esc_html( sprintf( _n( '%d image', '%d images', lsvr_townpress_get_gallery_images_count( get_the_ID() ), 'townpress' ), lsvr_townpress_get_gallery_images_count( get_the_ID() ) ) ); ?>

			</li>
			<!-- POST IMAGES COUNT : end -->

		<?php endif; ?>

	</ul>
	<!-- POST INFO : end -->

<?php endif; ?>