<?php if ( lsvr_townpress_has_listing_gallery( get_the_ID() ) ) : ?>

	<!-- POST GALLERY : begin -->
	<div class="post__gallery">

		<h2 class="post__gallery-title"><?php esc_html_e( 'Gallery', 'townpress' ); ?></h2>

		<ul class="post__gallery-list">

			<?php foreach ( lsvr_townpress_get_listing_gallery_images( get_the_ID() ) as $image_id ) : ?>

				<li class="post__gallery-item">

					<a href="<?php echo esc_url( lsvr_townpress_get_image_url( $image_id, 'full' ) ); ?>" class="post__gallery-item-link lsvr-open-in-lightbox"
						title="<?php echo esc_attr( lsvr_townpress_get_image_title( $image_id ) ); ?>">
						<img src="<?php echo esc_url( lsvr_townpress_get_image_url( $image_id, 'thumbnail' ) ); ?>"
							class="post__gallery-item-image" alt="<?php echo esc_attr( lsvr_townpress_get_image_alt( $image_id ) ); ?>">
					</a>

				</li>

			<?php endforeach; ?>

		</ul>

	</div>
	<!-- POST GALLERY : end -->

<?php endif; ?>