<?php if ( true === apply_filters( 'lsvr_townpress_post_single_post_footer_enable', true )
	&& ( true === apply_filters( 'lsvr_townpress_post_single_post_footer_date_enable', false )
		|| lsvr_townpress_has_post_terms( get_the_ID(), apply_filters( 'lsvr_townpress_post_category_taxonomy', '' ) )
		|| lsvr_townpress_has_post_terms( get_the_ID(), apply_filters( 'lsvr_townpress_post_tag_taxonomy', '' ) ) ) ) : ?>

	<!-- POST FOOTER : begin -->
	<footer class="post__footer">

		<!-- POST META : begin -->
		<ul class="post__meta" aria-label="<?php echo esc_attr( esc_html__( 'Post Meta', 'townpress' ) ); ?>">

			<?php if ( true === apply_filters( 'lsvr_townpress_post_single_post_footer_date_enable', false ) ) : ?>

				<!-- POST DATE : begin -->
				<li class="post__meta-item post__meta-item--date">

					<span class="post__meta-item-icon post__meta-item-icon--date" aria-hidden="true"></span>

					<span class="post__meta-date" role="group">
						<?php the_date(); ?>
					</span>

					<?php if ( true === apply_filters( 'lsvr_townpress_post_single_post_footer_author_enable', false ) ) : ?>

						<span class="post__meta-author"><?php echo sprintf( esc_html__( 'by %s', 'townpress' ), '<a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" class="post__meta-author-link" rel="author">' . get_the_author() . '</a>' ); ?></span>

					<?php endif; ?>

					<?php if ( lsvr_townpress_has_post_terms( get_the_ID(), apply_filters( 'lsvr_townpress_post_category_taxonomy', '' ) ) ) : ?>

						<span class="post__meta-categories"><?php lsvr_townpress_the_post_terms( get_the_ID(), apply_filters( 'lsvr_townpress_post_category_taxonomy', '' ), esc_html__( 'in %s', 'townpress' ) ); ?></span>

					<?php endif; ?>

				</li>
				<!-- POST DATE : end -->

			<?php elseif ( lsvr_townpress_has_post_terms( get_the_ID(), apply_filters( 'lsvr_townpress_post_category_taxonomy', '' ) ) ) : ?>

					<!-- POST CATEGORIES : begin -->
					<li class="post__meta-item post__meta-item--category" title="<?php echo esc_attr( esc_html__( 'Category', 'townpress' ) ); ?>">

						<span class="post__meta-item-icon post__meta-item-icon--category" aria-hidden="true"></span>

						<?php lsvr_townpress_the_post_terms( get_the_ID(), apply_filters( 'lsvr_townpress_post_category_taxonomy', '' ) ); ?>

					</li>
					<!-- POST CATEGORIES : end -->

			<?php endif; ?>

			<?php if ( lsvr_townpress_has_post_terms( get_the_ID(), apply_filters( 'lsvr_townpress_post_tag_taxonomy', '' ) ) ) : ?>

				<!-- POST TAGS : begin -->
				<li class="post__meta-item post__meta-item--tags" title="<?php echo esc_attr( esc_html__( 'Tags', 'townpress' ) ); ?>">

					<span class="post__meta-item-icon post__meta-item-icon--tags" aria-hidden="true"></span>

					<?php lsvr_townpress_the_post_terms( get_the_ID(), apply_filters( 'lsvr_townpress_post_tag_taxonomy', '' ) ); ?>

				</li>
				<!-- POST TAGS : end -->

			<?php endif; ?>

		</ul>
		<!-- POST META : end -->

	</footer>
	<!-- POST FOOTER : end -->

<?php endif; ?>